/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.BytesMessage;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.apache.activemq.usage.SystemUsage;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.listener.DefaultMessageListenerContainer;

public class AMQFailoverIssue
extends TestCase {
    private static final String URL1 = "tcp://localhost:61616";
    private static final String QUEUE1_NAME = "test.queue.1";
    private static final int MAX_CONSUMERS = 10;
    private static final int MAX_PRODUCERS = 5;
    private static final int NUM_MESSAGE_TO_SEND = 10000;
    private static final int TOTAL_MESSAGES = 50000;
    private static final boolean USE_FAILOVER = true;
    private AtomicInteger messageCount = new AtomicInteger();
    private CountDownLatch doneLatch;

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFailoverIssue() throws Exception {
        BrokerService brokerService1 = null;
        DefaultMessageListenerContainer container1 = null;
        try {
            brokerService1 = this.createBrokerService("broker1", URL1, null);
            brokerService1.start();
            ActiveMQConnectionFactory acf = this.createConnectionFactory(URL1, true);
            PooledConnectionFactory pcf = new PooledConnectionFactory(acf);
            this.doneLatch = new CountDownLatch(50000);
            container1 = this.createDefaultMessageListenerContainer(acf, new TestMessageListener1(0L), QUEUE1_NAME);
            container1.afterPropertiesSet();
            Thread.sleep(5000L);
            ExecutorService executor = Executors.newCachedThreadPool();
            for (int i = 0; i < 5; ++i) {
                executor.submit(new PooledProducerTask(pcf, QUEUE1_NAME));
            }
            AMQFailoverIssue.assertTrue((boolean)this.doneLatch.await(45L, TimeUnit.SECONDS));
            executor.shutdown();
            Assert.assertEquals((int)50000, (int)this.messageCount.get());
        }
        finally {
            container1.stop();
            container1.destroy();
            container1 = null;
            brokerService1.stop();
            brokerService1 = null;
        }
    }

    private BrokerService createBrokerService(String brokerName, String uri1, String uri2) throws Exception {
        BrokerService brokerService = new BrokerService();
        brokerService.setBrokerName(brokerName);
        brokerService.setPersistent(false);
        brokerService.setUseJmx(true);
        SystemUsage memoryManager = new SystemUsage();
        memoryManager.getMemoryUsage().setLimit(5000000L);
        brokerService.setSystemUsage(memoryManager);
        ArrayList<PolicyEntry> policyEntries = new ArrayList<PolicyEntry>();
        PolicyEntry entry = new PolicyEntry();
        entry.setQueue(">");
        entry.setMemoryLimit(1L);
        policyEntries.add(entry);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setPolicyEntries(policyEntries);
        brokerService.setDestinationPolicy(policyMap);
        TransportConnector tConnector = new TransportConnector();
        tConnector.setUri(new URI(uri1));
        tConnector.setName(brokerName + ".transportConnector");
        brokerService.addConnector(tConnector);
        if (uri2 != null) {
            DiscoveryNetworkConnector nc = new DiscoveryNetworkConnector(new URI("static:" + uri2));
            nc.setBridgeTempDestinations(true);
            nc.setBrokerName(brokerName);
            nc.setPrefetchSize(1);
            brokerService.addNetworkConnector(nc);
        }
        return brokerService;
    }

    public DefaultMessageListenerContainer createDefaultMessageListenerContainer(ConnectionFactory acf, MessageListener listener, String queue) {
        DefaultMessageListenerContainer container = new DefaultMessageListenerContainer();
        container.setConnectionFactory(acf);
        container.setDestinationName(queue);
        container.setMessageListener((Object)listener);
        container.setSessionTransacted(false);
        container.setSessionAcknowledgeMode(1);
        container.setConcurrentConsumers(10);
        return container;
    }

    public ActiveMQConnectionFactory createConnectionFactory(String url, boolean useFailover) {
        String failoverUrl = "failover:(" + url + ")";
        ActiveMQConnectionFactory acf = new ActiveMQConnectionFactory(useFailover ? failoverUrl : url);
        acf.setCopyMessageOnSend(false);
        acf.setUseAsyncSend(false);
        acf.setDispatchAsync(true);
        acf.setUseCompression(false);
        acf.setOptimizeAcknowledge(false);
        acf.setOptimizedMessageDispatch(true);
        acf.setUseAsyncSend(false);
        return acf;
    }

    private static class PooledProducerTask
    implements Runnable {
        private final String queueName;
        private final PooledConnectionFactory pcf;

        public PooledProducerTask(PooledConnectionFactory pcf, String queueName) {
            this.pcf = pcf;
            this.queueName = queueName;
        }

        public void run() {
            try {
                JmsTemplate jmsTemplate = new JmsTemplate((ConnectionFactory)this.pcf);
                jmsTemplate.setDeliveryMode(1);
                jmsTemplate.setExplicitQosEnabled(true);
                jmsTemplate.setMessageIdEnabled(false);
                jmsTemplate.setMessageTimestampEnabled(false);
                jmsTemplate.afterPropertiesSet();
                final byte[] bytes = new byte[2048];
                Random r = new Random();
                r.nextBytes(bytes);
                Thread.sleep(2000L);
                final AtomicInteger count = new AtomicInteger();
                for (int i = 0; i < 10000; ++i) {
                    jmsTemplate.send(this.queueName, new MessageCreator(){

                        public Message createMessage(Session session) throws JMSException {
                            BytesMessage message = session.createBytesMessage();
                            message.writeBytes(bytes);
                            message.setIntProperty("count", count.incrementAndGet());
                            message.setStringProperty("producer", "pooled");
                            return message;
                        }
                    });
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private class TestMessageListener1
    implements MessageListener {
        private final long waitTime;

        public TestMessageListener1(long waitTime) {
            this.waitTime = waitTime;
        }

        public void onMessage(Message msg) {
            try {
                AMQFailoverIssue.this.messageCount.incrementAndGet();
                AMQFailoverIssue.this.doneLatch.countDown();
                Thread.sleep(this.waitTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

