/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import java.util.ArrayList;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.usage.SystemUsage;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class AMQStackOverFlowTest
extends TestCase {
    private static final String URL1 = "tcp://localhost:61616";
    private static final String URL2 = "tcp://localhost:61617";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStackOverflow() throws Exception {
        BrokerService brokerService1 = null;
        BrokerService brokerService2 = null;
        try {
            brokerService1 = this.createBrokerService("broker1", URL1, URL2);
            brokerService1.start();
            brokerService2 = this.createBrokerService("broker2", URL2, URL1);
            brokerService2.start();
            ActiveMQConnectionFactory cf1 = new ActiveMQConnectionFactory(URL1);
            cf1.setUseAsyncSend(false);
            ActiveMQConnectionFactory cf2 = new ActiveMQConnectionFactory(URL2);
            cf2.setUseAsyncSend(false);
            JmsTemplate template1 = new JmsTemplate((ConnectionFactory)cf1);
            template1.setReceiveTimeout(10000L);
            template1.send("test.q", new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    return session.createTextMessage("test");
                }
            });
            JmsTemplate template2 = new JmsTemplate((ConnectionFactory)cf2);
            template2.setReceiveTimeout(10000L);
            Message m = template2.receive("test.q");
            AMQStackOverFlowTest.assertTrue((boolean)(m instanceof TextMessage));
            TextMessage tm = (TextMessage)m;
            Assert.assertEquals((String)"test", (String)tm.getText());
            template2.send("test2.q", new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    return session.createTextMessage("test2");
                }
            });
            Message m2 = template1.receive("test2.q");
            AMQStackOverFlowTest.assertNotNull((Object)m2);
            AMQStackOverFlowTest.assertTrue((boolean)(m2 instanceof TextMessage));
            TextMessage tm2 = (TextMessage)m2;
            Assert.assertEquals((String)"test2", (String)tm2.getText());
        }
        finally {
            brokerService1.stop();
            brokerService1 = null;
            brokerService2.stop();
            brokerService2 = null;
        }
    }

    private BrokerService createBrokerService(String brokerName, String uri1, String uri2) throws Exception {
        BrokerService brokerService = new BrokerService();
        brokerService.setBrokerName(brokerName);
        brokerService.setPersistent(false);
        brokerService.setUseJmx(true);
        SystemUsage memoryManager = new SystemUsage();
        brokerService.setSystemUsage(memoryManager);
        ArrayList<PolicyEntry> policyEntries = new ArrayList<PolicyEntry>();
        PolicyEntry entry = new PolicyEntry();
        entry.setQueue(">");
        policyEntries.add(entry);
        PolicyMap policyMap = new PolicyMap();
        policyMap.setPolicyEntries(policyEntries);
        brokerService.setDestinationPolicy(policyMap);
        TransportConnector tConnector = new TransportConnector();
        tConnector.setUri(new URI(uri1));
        tConnector.setName(brokerName + ".transportConnector");
        brokerService.addConnector(tConnector);
        if (uri2 != null) {
            DiscoveryNetworkConnector nc = new DiscoveryNetworkConnector(new URI("static:" + uri2));
            nc.setBridgeTempDestinations(true);
            nc.setBrokerName(brokerName);
            brokerService.addNetworkConnector(nc);
        }
        return brokerService;
    }
}

