/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;

public class CreateTemporaryQueueBeforeStartTest
extends TestCase {
    protected String bindAddress = "tcp://localhost:61621";
    private Connection connection;
    private BrokerService broker = new BrokerService();

    public void testCreateTemporaryQueue() throws Exception {
        this.connection = this.createConnection();
        Session session = this.connection.createSession(false, 1);
        TemporaryQueue queue = session.createTemporaryQueue();
        CreateTemporaryQueueBeforeStartTest.assertTrue((String)"No queue created!", (queue != null ? 1 : 0) != 0);
        TemporaryTopic topic = session.createTemporaryTopic();
        CreateTemporaryQueueBeforeStartTest.assertTrue((String)"No topic created!", (topic != null ? 1 : 0) != 0);
    }

    public void testTryToReproduceNullPointerBug() throws Exception {
        String url = this.bindAddress;
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(url);
        QueueConnection queueConnection = factory.createQueueConnection();
        this.connection = queueConnection;
        QueueSession session = queueConnection.createQueueSession(false, 1);
        session.createSender(null);
        TemporaryQueue receiverQueue = session.createTemporaryQueue();
        session.createReceiver(receiverQueue);
        queueConnection.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTemporaryQueueConsumer() throws Exception {
        int number = 20;
        final AtomicInteger count = new AtomicInteger(0);
        for (int i = 0; i < 20; ++i) {
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block5: {
                        try {
                            QueueConnection connection = CreateTemporaryQueueBeforeStartTest.this.createConnection();
                            QueueSession session = connection.createQueueSession(false, 1);
                            TemporaryQueue queue = session.createTemporaryQueue();
                            session.createReceiver(queue);
                            connection.start();
                            if (count.incrementAndGet() < 20) break block5;
                            AtomicInteger atomicInteger = count;
                            synchronized (atomicInteger) {
                                count.notify();
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            });
            thread.start();
        }
        int maxWaitTime = 20000;
        AtomicInteger atomicInteger = count;
        synchronized (atomicInteger) {
            long waitTime = maxWaitTime;
            long start = System.currentTimeMillis();
            while (count.get() < 20 && waitTime > 0L) {
                count.wait(waitTime);
                waitTime = (long)maxWaitTime - (System.currentTimeMillis() - start);
            }
        }
        CreateTemporaryQueueBeforeStartTest.assertTrue((String)("Unexpected count: " + count), (count.get() == 20 ? 1 : 0) != 0);
    }

    protected QueueConnection createConnection() throws Exception {
        ActiveMQConnectionFactory factory = this.createConnectionFactory();
        return factory.createQueueConnection();
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.bindAddress);
    }

    protected void setUp() throws Exception {
        this.broker.setPersistent(false);
        this.broker.addConnector(this.bindAddress);
        this.broker.start();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        this.broker.stop();
        super.tearDown();
    }
}

