/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.usecases.MultiBrokersMultiClientsTest;

public class MultiBrokersMultiClientsUsingTcpTest
extends MultiBrokersMultiClientsTest {
    protected List<DemandForwardingBridge> bridges;

    protected void bridgeAllBrokers(String groupName) throws Exception {
        for (int i = 1; i <= 2; ++i) {
            for (int j = 1; j <= 2; ++j) {
                if (i == j) continue;
                this.bridgeBrokers("Broker" + i, "Broker" + j);
            }
        }
        maxSetupTime = 5000;
    }

    protected void bridgeBrokers(BrokerService localBroker, BrokerService remoteBroker) throws Exception {
        URI localURI;
        URI remoteURI;
        List<TransportConnector> remoteTransports = remoteBroker.getTransportConnectors();
        List<TransportConnector> localTransports = localBroker.getTransportConnectors();
        if (!remoteTransports.isEmpty() && !localTransports.isEmpty()) {
            remoteURI = remoteTransports.get(0).getConnectUri();
            localURI = localTransports.get(0).getConnectUri();
            if (!remoteURI.toString().startsWith("tcp:") || !localURI.toString().startsWith("tcp:")) {
                throw new Exception("Remote broker or local broker is not using tcp connectors");
            }
        } else {
            throw new Exception("Remote broker or local broker has no registered connectors.");
        }
        NetworkBridgeConfiguration config = new NetworkBridgeConfiguration();
        config.setBrokerName(localBroker.getBrokerName());
        DemandForwardingBridge bridge = new DemandForwardingBridge(config, TransportFactory.connect(localURI), TransportFactory.connect(remoteURI));
        this.bridges.add(bridge);
        bridge.start();
    }

    public void setUp() throws Exception {
        super.setUp();
        int j = 0;
        Iterator i = this.brokers.values().iterator();
        while (i.hasNext()) {
            ((JmsMultipleBrokersTestSupport.BrokerItem)i.next()).broker.addConnector("tcp://localhost:" + (61616 + j++));
        }
        this.bridges = new ArrayList<DemandForwardingBridge>();
    }
}

