/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.Set;
import javax.jms.Destination;
import javax.jms.Session;
import org.apache.activemq.EmbeddedBrokerAndConnectionTestSupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NewConsumerCreatesDestinationTest
extends EmbeddedBrokerAndConnectionTestSupport {
    private static final Log LOG = LogFactory.getLog(NewConsumerCreatesDestinationTest.class);
    private ActiveMQQueue wildcard;

    public void testNewConsumerCausesNewDestinationToBeAutoCreated() throws Exception {
        String wildcardText = "org.*" + this.getDestinationString().substring("org.apache".length());
        this.wildcard = new ActiveMQQueue(wildcardText);
        LOG.info("Using wildcard: " + this.wildcard);
        LOG.info("on destination: " + this.destination);
        this.assertDestinationCreated(this.destination, false);
        this.assertDestinationCreated(this.wildcard, false);
        Session session = this.connection.createSession(false, 1);
        session.createConsumer(this.destination);
        this.assertDestinationCreated(this.destination, true);
        this.assertDestinationCreated(this.wildcard, true);
    }

    protected void assertDestinationCreated(Destination destination, boolean expected) throws Exception {
        Set<org.apache.activemq.broker.region.Destination> answer = this.broker.getBroker().getDestinations((ActiveMQDestination)destination);
        int size = expected ? 1 : 0;
        NewConsumerCreatesDestinationTest.assertEquals((String)("Size of found destinations: " + answer), (int)size, (int)answer.size());
    }
}

