/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.util.IOHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PublishOnQueueConsumedMessageInTransactionTest
extends TestCase
implements MessageListener {
    private static final Log LOG = LogFactory.getLog(PublishOnQueueConsumedMessageInTransactionTest.class);
    private Session producerSession;
    private Session consumerSession;
    private Destination queue;
    private ActiveMQConnectionFactory factory;
    private MessageProducer producer;
    private MessageConsumer consumer;
    private Connection connection;
    private ObjectMessage objectMessage;
    private List<Message> messages = this.createConcurrentList();
    private final Object lock = new Object();
    private String[] data;
    private String dataFileRoot = IOHelper.getDefaultDataDirectory();
    private int messageCount = 3;
    private String url = "vm://localhost";

    protected void setUp() throws Exception {
        File dataFile = new File(this.dataFileRoot);
        PublishOnQueueConsumedMessageInTransactionTest.recursiveDelete(dataFile);
        try {
            this.factory = new ActiveMQConnectionFactory(this.url);
            this.connection = this.factory.createConnection();
            this.producerSession = this.connection.createSession(true, 0);
            this.consumerSession = this.connection.createSession(true, 0);
            this.queue = new ActiveMQQueue("FOO.BAR");
            this.data = new String[this.messageCount];
            for (int i = 0; i < this.messageCount; ++i) {
                this.data[i] = "Message : " + i;
            }
        }
        catch (JMSException je) {
            PublishOnQueueConsumedMessageInTransactionTest.fail((String)("Error setting up connection : " + je.toString()));
        }
    }

    public void testSendReceive() throws Exception {
        this.sendMessage();
        this.connection.start();
        this.consumer = this.consumerSession.createConsumer(this.queue);
        this.consumer.setMessageListener(this);
        this.waitForMessagesToBeDelivered();
        PublishOnQueueConsumedMessageInTransactionTest.assertEquals((String)"Messages received doesn't equal messages sent", (int)this.messages.size(), (int)this.data.length);
    }

    protected void sendMessage() throws JMSException {
        this.messages.clear();
        try {
            for (int i = 0; i < this.data.length; ++i) {
                this.producer = this.producerSession.createProducer(this.queue);
                this.objectMessage = this.producerSession.createObjectMessage((Serializable)((Object)this.data[i]));
                this.producer.send(this.objectMessage);
                this.producerSession.commit();
                LOG.info("sending message :" + this.objectMessage);
            }
        }
        catch (Exception e) {
            if (this.producerSession != null) {
                this.producerSession.rollback();
                LOG.info("rollback");
                this.producerSession.close();
            }
            e.printStackTrace();
        }
    }

    @Override
    public synchronized void onMessage(Message m) {
        try {
            this.objectMessage = (ObjectMessage)m;
            this.consumeMessage(this.objectMessage, this.messages);
            LOG.info("consumer received message :" + this.objectMessage);
            this.consumerSession.commit();
        }
        catch (Exception e) {
            try {
                this.consumerSession.rollback();
                LOG.info("rolled back transaction");
            }
            catch (JMSException e1) {
                LOG.info(e1);
                e1.printStackTrace();
            }
            LOG.info(e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeMessage(Message message, List<Message> messageList) {
        messageList.add(message);
        if (messageList.size() >= this.data.length) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    protected List<Message> createConcurrentList() {
        return Collections.synchronizedList(new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForMessagesToBeDelivered() {
        long maxWaitTime;
        long waitTime = maxWaitTime = 5000L;
        long start = maxWaitTime <= 0L ? 0L : System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            while (this.messages.size() <= this.data.length && waitTime >= 0L) {
                try {
                    this.lock.wait(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                waitTime = maxWaitTime - (System.currentTimeMillis() - start);
            }
        }
    }

    protected static void recursiveDelete(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                PublishOnQueueConsumedMessageInTransactionTest.recursiveDelete(files[i]);
            }
        }
        file.delete();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }
}

