/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.usecases.ThreeBrokerTopicNetworkTest;

public class ThreeBrokerTopicNetworkUsingTcpTest
extends ThreeBrokerTopicNetworkTest {
    protected List<DemandForwardingBridge> bridges;

    protected void bridgeBrokers(BrokerService localBroker, BrokerService remoteBroker) throws Exception {
        URI localURI;
        URI remoteURI;
        List<TransportConnector> remoteTransports = remoteBroker.getTransportConnectors();
        List<TransportConnector> localTransports = localBroker.getTransportConnectors();
        if (!remoteTransports.isEmpty() && !localTransports.isEmpty()) {
            remoteURI = remoteTransports.get(0).getConnectUri();
            localURI = localTransports.get(0).getConnectUri();
            if (!remoteURI.toString().startsWith("tcp:") || !localURI.toString().startsWith("tcp:")) {
                throw new Exception("Remote broker or local broker is not using tcp connectors");
            }
        } else {
            throw new Exception("Remote broker or local broker has no registered connectors.");
        }
        NetworkBridgeConfiguration config = new NetworkBridgeConfiguration();
        config.setBrokerName(localBroker.getBrokerName());
        DemandForwardingBridge bridge = new DemandForwardingBridge(config, TransportFactory.connect(localURI), TransportFactory.connect(remoteURI));
        this.bridges.add(bridge);
        bridge.start();
        maxSetupTime = 2000;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.bridges = new ArrayList<DemandForwardingBridge>();
    }
}

