/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="dataformat,transformation,json", title="Boon")
@XmlRootElement(name="boon")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BoonDataFormat
extends DataFormatDefinition {
    @XmlAttribute(required=true)
    private String unmarshalTypeName;
    @XmlTransient
    private Class<?> unmarshalType;

    public BoonDataFormat() {
        super("boon");
    }

    public BoonDataFormat(Class<?> unmarshalType) {
        this();
        this.setUnmarshalType(unmarshalType);
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    @Override
    protected DataFormat createDataFormat(RouteContext routeContext) {
        if (this.unmarshalType == null && this.unmarshalTypeName != null) {
            try {
                this.unmarshalType = routeContext.getCamelContext().getClassResolver().resolveMandatoryClass(this.unmarshalTypeName);
            }
            catch (ClassNotFoundException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return super.createDataFormat(routeContext);
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        if (this.unmarshalType != null) {
            this.setProperty(camelContext, dataFormat, "unmarshalType", this.unmarshalType);
        }
    }
}

