/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.as2.AS2Configuration;
import org.apache.camel.component.as2.api.AS2ClientConnection;
import org.apache.camel.component.as2.api.AS2ServerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AS2ConnectionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AS2ConnectionHelper.class);
    private static Map<Integer, AS2ServerConnection> serverConnections = new HashMap<Integer, AS2ServerConnection>();

    private AS2ConnectionHelper() {
    }

    public static AS2ClientConnection createAS2ClientConnection(AS2Configuration configuration) throws IOException {
        return new AS2ClientConnection(configuration.getAs2Version(), configuration.getUserAgent(), configuration.getClientFqdn(), configuration.getTargetHostname(), Integer.valueOf(configuration.getTargetPortNumber()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AS2ServerConnection createAS2ServerConnection(AS2Configuration configuration) throws IOException {
        Map<Integer, AS2ServerConnection> map = serverConnections;
        synchronized (map) {
            AS2ServerConnection serverConnection = serverConnections.get(configuration.getServerPortNumber());
            if (serverConnection == null) {
                serverConnection = new AS2ServerConnection(configuration.getAs2Version(), configuration.getServer(), configuration.getServerFqdn(), configuration.getServerPortNumber(), configuration.getSigningAlgorithm(), configuration.getSigningCertificateChain(), configuration.getSigningPrivateKey(), configuration.getDecryptingPrivateKey(), configuration.getMdnMessageTemplate());
                serverConnections.put(configuration.getServerPortNumber(), serverConnection);
            }
            return serverConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllServerConnections() {
        Map<Integer, AS2ServerConnection> map = serverConnections;
        synchronized (map) {
            for (Map.Entry<Integer, AS2ServerConnection> entry : serverConnections.entrySet()) {
                try {
                    int port = entry.getKey();
                    LOG.debug("Stopping and closing AS2ServerConnection on port: {}", (Object)port);
                    AS2ServerConnection conn = entry.getValue();
                    conn.close();
                }
                catch (Exception e) {
                    LOG.debug("Error stopping and closing AS2ServerConnection due to " + e.getMessage() + ". This exception is ignored", (Throwable)e);
                }
            }
        }
        serverConnections.clear();
    }
}

