/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmos;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class AtmosEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":name/operation";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "atmos".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "name", null, false, copy);
        uri = this.buildPathParameter(syntax, uri, "operation", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(14);
        props.add("remotePath");
        props.add("secretKey");
        props.add("query");
        props.add("exchangePattern");
        props.add("uri");
        props.add("lazyStartProducer");
        props.add("bridgeErrorHandler");
        props.add("fullTokenId");
        props.add("name");
        props.add("localPath");
        props.add("newRemotePath");
        props.add("sslValidation");
        props.add("operation");
        props.add("exceptionHandler");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("fullTokenId");
        secretProps.add("secretKey");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

