/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.braintree;

import com.braintreegateway.BraintreeGateway;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.braintree.BraintreeConfiguration;
import org.apache.camel.component.braintree.BraintreeEndpoint;
import org.apache.camel.component.braintree.internal.BraintreeApiCollection;
import org.apache.camel.component.braintree.internal.BraintreeApiName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.component.AbstractApiComponent;
import org.apache.camel.support.component.ApiCollection;

@Component(value="braintree")
public class BraintreeComponent
extends AbstractApiComponent<BraintreeApiName, BraintreeConfiguration, BraintreeApiCollection> {
    @Metadata
    private BraintreeConfiguration configuration;
    private final Map<String, BraintreeGateway> gateways = new ConcurrentHashMap<String, BraintreeGateway>();

    public BraintreeComponent() {
        super(BraintreeApiName.class, (ApiCollection)BraintreeApiCollection.getCollection());
    }

    public BraintreeComponent(CamelContext context) {
        super(context, BraintreeApiName.class, (ApiCollection)BraintreeApiCollection.getCollection());
    }

    protected BraintreeApiName getApiName(String apiNameStr) {
        return (BraintreeApiName)((Object)this.getCamelContext().getTypeConverter().convertTo(BraintreeApiName.class, (Object)apiNameStr));
    }

    protected Endpoint createEndpoint(String uri, String methodName, BraintreeApiName apiName, BraintreeConfiguration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        this.configuration = endpointConfiguration;
        return new BraintreeEndpoint(uri, this, apiName, methodName, endpointConfiguration);
    }

    public BraintreeGateway getGateway(BraintreeConfiguration configuration) {
        BraintreeGateway gateway = configuration.getAccessToken() != null ? this.gateways.computeIfAbsent(configuration.getAccessToken(), k -> configuration.newBraintreeGateway()) : this.gateways.computeIfAbsent(configuration.getMerchantId(), k -> configuration.newBraintreeGateway());
        return gateway;
    }
}

