/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.mvel;

import java.io.Serializable;
import java.util.Map;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.Predicate;
import org.apache.camel.language.mvel.MvelExpression;
import org.apache.camel.spi.ScriptingLanguage;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.LanguageSupport;
import org.mvel2.MVEL;

@Language(value="mvel")
public class MvelLanguage
extends LanguageSupport
implements ScriptingLanguage {
    public Predicate createPredicate(String expression) {
        expression = this.loadResource(expression);
        return new MvelExpression(this, expression, Boolean.class);
    }

    public Expression createExpression(String expression) {
        expression = this.loadResource(expression);
        return new MvelExpression(this, expression, Object.class);
    }

    public <T> T evaluate(String script, Map<String, Object> bindings, Class<T> resultType) {
        script = this.loadResource(script);
        try {
            Serializable compiled = MVEL.compileExpression((String)script);
            Object value = MVEL.executeExpression((Object)compiled, bindings);
            return (T)this.getCamelContext().getTypeConverter().convertTo(resultType, value);
        }
        catch (Exception e) {
            throw new ExpressionIllegalSyntaxException(script, (Throwable)e);
        }
    }
}

