/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.ws;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.spring.ws.SpringWebserviceConfiguration;
import org.apache.camel.component.spring.ws.SpringWebserviceEndpoint;
import org.apache.camel.component.spring.ws.bean.CamelEndpointDispatcher;
import org.apache.camel.component.spring.ws.bean.CamelSpringWSEndpointMapping;
import org.apache.camel.component.spring.ws.filter.MessageFilter;
import org.apache.camel.component.spring.ws.filter.impl.BasicMessageFilter;
import org.apache.camel.component.spring.ws.type.EndpointMappingType;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;

@org.apache.camel.spi.annotations.Component(value="spring-ws")
public class SpringWebserviceComponent
extends DefaultComponent
implements SSLContextParametersAware {
    private static final Logger LOG = LoggerFactory.getLogger(SpringWebserviceComponent.class);
    @Metadata(label="security")
    private boolean useGlobalSslContextParameters;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SpringWebserviceConfiguration configuration = new SpringWebserviceConfiguration();
        this.addConsumerConfiguration(remaining, parameters, configuration);
        SpringWebserviceEndpoint endpoint = new SpringWebserviceEndpoint((Component)this, uri, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        this.configureProducerConfiguration(remaining, configuration);
        this.configureMessageFilter(configuration);
        if (configuration.getSslContextParameters() == null) {
            configuration.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        return endpoint;
    }

    private void addConsumerConfiguration(String remaining, Map<String, Object> parameters, SpringWebserviceConfiguration configuration) {
        EndpointMappingType type = EndpointMappingType.getTypeFromUriPrefix(remaining);
        if (type != null) {
            LOG.debug("Building Spring Web Services consumer of type {}", (Object)type);
            String lookupKey = this.getLookupKey(remaining, type);
            configuration.setEndpointMappingType(type);
            configuration.setEndpointMappingLookupKey(lookupKey);
            if (EndpointMappingType.BEANNAME.equals((Object)type)) {
                this.addEndpointDispatcherToConfiguration(configuration, lookupKey);
            } else {
                this.addEndpointMappingToConfiguration(parameters, configuration);
                if (type.equals((Object)EndpointMappingType.XPATHRESULT)) {
                    String expression = (String)this.getAndRemoveParameter(parameters, "expression", String.class);
                    configuration.setExpression(expression);
                    XPathExpression xPathExpression = this.createXPathExpression(expression);
                    configuration.setxPathExpression(xPathExpression);
                }
            }
        }
    }

    private void configureProducerConfiguration(String remaining, SpringWebserviceConfiguration configuration) throws URISyntaxException {
        if (configuration.getEndpointMapping() == null && configuration.getEndpointDispatcher() == null) {
            LOG.debug("Building Spring Web Services producer");
            URI webServiceEndpointUri = new URI(UnsafeUriCharactersEncoder.encode((String)remaining));
            WebServiceTemplate webServiceTemplate = configuration.getWebServiceTemplate();
            if (webServiceTemplate == null) {
                webServiceTemplate = new WebServiceTemplate();
                configuration.setWebServiceTemplate(webServiceTemplate);
            }
            if (webServiceTemplate.getDefaultUri() == null) {
                String uri = webServiceEndpointUri.toString();
                webServiceTemplate.setDefaultUri(uri);
                configuration.setWebServiceEndpointUri(uri);
            }
            if (configuration.getMessageSender() != null) {
                webServiceTemplate.setMessageSender(configuration.getMessageSender());
            }
            if (configuration.getMessageFactory() != null) {
                webServiceTemplate.setMessageFactory(configuration.getMessageFactory());
            }
        }
    }

    private String getLookupKey(String remaining, EndpointMappingType type) {
        String lookupKey = remaining.substring(type.getPrefix().length());
        lookupKey = lookupKey.startsWith("//") ? lookupKey.substring(2) : lookupKey;
        return SpringWebserviceConfiguration.decode(lookupKey);
    }

    private XPathExpression createXPathExpression(String xpathExpression) {
        if (xpathExpression == null) {
            throw new RuntimeCamelException("Expression parameter is required when using XPath endpoint mapping");
        }
        return XPathExpressionFactory.createXPathExpression((String)xpathExpression);
    }

    private void addEndpointMappingToConfiguration(Map<String, Object> parameters, SpringWebserviceConfiguration configuration) {
        CamelSpringWSEndpointMapping endpointMapping = (CamelSpringWSEndpointMapping)this.resolveAndRemoveReferenceParameter(parameters, "endpointMapping", CamelSpringWSEndpointMapping.class, null);
        if (endpointMapping == null && configuration.getEndpointDispatcher() == null) {
            throw new IllegalArgumentException("No instance of CamelSpringWSEndpointMapping found in Spring ApplicationContext. This bean is required for Spring-WS consumer support (unless the 'spring-ws:beanname:' URI scheme is used)");
        }
        configuration.setEndpointMapping(endpointMapping);
    }

    private void addEndpointDispatcherToConfiguration(SpringWebserviceConfiguration configuration, String lookupKey) {
        CamelEndpointDispatcher endpoint = (CamelEndpointDispatcher)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)lookupKey, CamelEndpointDispatcher.class);
        configuration.setEndpointDispatcher(endpoint);
    }

    private void configureMessageFilter(SpringWebserviceConfiguration configuration) {
        if (configuration.getMessageFilter() == null) {
            MessageFilter globalMessageFilter = (MessageFilter)EndpointHelper.resolveReferenceParameter((CamelContext)this.getCamelContext(), (String)"messageFilter", MessageFilter.class, (boolean)false);
            if (globalMessageFilter != null) {
                configuration.setMessageFilter(globalMessageFilter);
            } else {
                configuration.setMessageFilter(new BasicMessageFilter());
            }
        }
    }

    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }
}

