/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tracing.decorators;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.tracing.SpanAdapter;
import org.apache.camel.tracing.decorators.AbstractSpanDecorator;

public class MongoDBSpanDecorator
extends AbstractSpanDecorator {
    @Override
    public String getComponent() {
        return "mongodb";
    }

    @Override
    public String getComponentClassName() {
        return "org.apache.camel.component.mongodb.MongoDbComponent";
    }

    @Override
    public String getOperationName(Exchange exchange, Endpoint endpoint) {
        Map<String, String> queryParameters = MongoDBSpanDecorator.toQueryParameters(endpoint.getEndpointUri());
        String opName = queryParameters.get("operation");
        if (opName != null) {
            return opName;
        }
        return super.getOperationName(exchange, endpoint);
    }

    @Override
    public void pre(SpanAdapter span, Exchange exchange, Endpoint endpoint) {
        super.pre(span, exchange, endpoint);
        span.setTag("db.system", this.getComponent());
        Map<String, String> queryParameters = MongoDBSpanDecorator.toQueryParameters(endpoint.getEndpointUri());
        String database = queryParameters.get("database");
        if (database != null) {
            span.setTag("db.name", database);
        }
        span.setTag("db.statement", queryParameters.toString());
    }
}

