/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.zipkin;

import brave.SpanCustomizer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.zipkin.ZipkinHelper;
import org.apache.camel.zipkin.ZipkinTracer;

class ZipkinClientResponseAdaptor {
    private final ZipkinTracer eventNotifier;
    private final String url;

    ZipkinClientResponseAdaptor(ZipkinTracer eventNotifier, Endpoint endpoint) {
        this.eventNotifier = eventNotifier;
        this.url = URISupport.sanitizeUri((String)endpoint.getEndpointUri());
    }

    void onResponse(Exchange exchange, SpanCustomizer span) {
        String responseCode;
        span.tag("camel.client.endpoint.url", this.url);
        span.tag("camel.client.exchange.id", exchange.getExchangeId());
        span.tag("camel.client.exchange.pattern", exchange.getPattern().name());
        if (this.eventNotifier.isIncludeMessageBody() || this.eventNotifier.isIncludeMessageBodyStreams()) {
            boolean streams = this.eventNotifier.isIncludeMessageBodyStreams();
            StreamCache cache = ZipkinHelper.prepareBodyForLogging(exchange, streams);
            String body = MessageHelper.extractBodyForLogging((Message)exchange.getMessage(), (String)"", (boolean)streams, (boolean)streams);
            span.tag("camel.client.exchange.message.response.body", body);
            if (cache != null) {
                cache.reset();
            }
        }
        if ((responseCode = (String)exchange.getMessage().getHeader("CamelHttpResponseCode", String.class)) != null) {
            span.tag("camel.client.exchange.message.response.code", responseCode);
        }
    }
}

