/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.cassandra.auth.AbstractCIDRAuthorizer;
import org.apache.cassandra.auth.AuthCacheService;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.CIDRGroupsMappingCache;
import org.apache.cassandra.auth.CIDRPermissions;
import org.apache.cassandra.auth.CIDRPermissionsCache;
import org.apache.cassandra.auth.ICIDRAuthorizer;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.utils.MonotonicClock;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraCIDRAuthorizer
extends AbstractCIDRAuthorizer {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticatedUser.class);
    private static final NoSpamLogger noSpamLogger = NoSpamLogger.getLogger(logger, 1L, TimeUnit.MINUTES);
    protected static CIDRPermissionsCache cidrPermissionsCache;
    protected static CIDRGroupsMappingCache cidrGroupsMappingCache;

    @Override
    public void setup() {
        this.commonSetup();
        cidrPermissionsCache = new CIDRPermissionsCache(this::getCidrPermissionsForRole, this.bulkLoadCidrPermsCache(), this::requireAuthorization);
        cidrGroupsMappingCache = new CIDRGroupsMappingCache(cidrGroupsMappingManager, cidrAuthorizerMetrics);
    }

    @Override
    public void initCaches() {
        AuthCacheService.instance.register(cidrPermissionsCache);
        this.loadCidrGroupsCache();
    }

    private CIDRPermissions getCidrPermissionsForRole(RoleResource role) {
        return cidrPermissionsManager.getCidrPermissionsForRole(role);
    }

    private Supplier<Map<RoleResource, CIDRPermissions>> bulkLoadCidrPermsCache() {
        return cidrPermissionsManager.bulkLoader();
    }

    @Override
    public boolean invalidateCidrPermissionsCache(String roleName) {
        if (roleName == null || roleName.isEmpty()) {
            cidrPermissionsCache.invalidate();
            return true;
        }
        return cidrPermissionsCache.invalidateCidrPermissions(roleName);
    }

    @Override
    public void loadCidrGroupsCache() {
        cidrGroupsMappingCache.loadCidrGroupsCache();
    }

    @Override
    public Set<String> lookupCidrGroupsForIp(InetAddress ip) {
        return cidrGroupsMappingCache.lookupCidrGroupsForIp(ip);
    }

    @VisibleForTesting
    protected boolean isMonitorMode() {
        return DatabaseDescriptor.getCidrAuthorizerMode() == ICIDRAuthorizer.CIDRAuthorizerMode.MONITOR;
    }

    private boolean hasCidrAccess(RoleResource role, InetAddress ipAddress) {
        CIDRPermissions cidrPermissions = (CIDRPermissions)cidrPermissionsCache.get(role);
        if (!cidrPermissions.restrictsAccess() && !this.isMonitorMode()) {
            return true;
        }
        Set<String> cidrGroups = this.lookupCidrGroupsForIp(ipAddress);
        if (this.isMonitorMode()) {
            if (cidrGroups != null && !cidrPermissions.canAccessFrom(cidrGroups)) {
                noSpamLogger.warn("Role {} accessed from unauthorized IP {}, CIDR group {}", role.getRoleName(), ipAddress.getHostAddress(), cidrGroups);
            } else {
                noSpamLogger.info("Role {} accessed from IP {}, CIDR group {}", role.getRoleName(), ipAddress.getHostAddress(), cidrGroups);
            }
            cidrAuthorizerMetrics.incrAcceptedAccessCount(cidrGroups);
            return true;
        }
        if (cidrGroups == null || cidrGroups.isEmpty() || !cidrPermissions.canAccessFrom(cidrGroups)) {
            cidrAuthorizerMetrics.incrRejectedAccessCount(cidrGroups);
            return false;
        }
        cidrAuthorizerMetrics.incrAcceptedAccessCount(cidrGroups);
        return true;
    }

    @Override
    public boolean hasAccessFromIp(RoleResource role, InetAddress ipAddress) {
        long startTimeNanos = MonotonicClock.Global.approxTime.now();
        boolean hasAccess = this.hasCidrAccess(role, ipAddress);
        CassandraCIDRAuthorizer.cidrAuthorizerMetrics.cidrChecksLatency.update(MonotonicClock.Global.approxTime.now() - startTimeNanos, TimeUnit.NANOSECONDS);
        return hasAccess;
    }
}

