/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.BiPredicate;

public class Overlaps {
    public static <E> List<Set<E>> constructOverlapSets(List<E> items, BiPredicate<E, E> startsAfter, Comparator<E> startsComparator, Comparator<E> endsComparator) {
        ArrayList<Set<HashSet<E>>> overlaps = new ArrayList<Set<HashSet<E>>>();
        if (items.isEmpty()) {
            return overlaps;
        }
        PriorityQueue<E> active = new PriorityQueue<E>(endsComparator);
        items.sort(startsComparator);
        for (E item : items) {
            if (!active.isEmpty() && startsAfter.test(item, active.peek())) {
                overlaps.add(new HashSet<E>(active));
                do {
                    active.poll();
                } while (!active.isEmpty() && startsAfter.test(item, active.peek()));
            }
            active.add(item);
        }
        assert (!active.isEmpty());
        overlaps.add(new HashSet<E>(active));
        return overlaps;
    }

    public static <E, B> List<B> assignOverlapsIntoBuckets(int threshold, InclusionMethod inclusionMethod, List<Set<E>> overlaps, BucketMaker<E, B> bucketer) {
        ArrayList<B> buckets = new ArrayList<B>();
        int regionCount = overlaps.size();
        int lastEnd = -1;
        for (int i = 0; i < regionCount; ++i) {
            Set<E> bucket = overlaps.get(i);
            int maxOverlap = bucket.size();
            if (maxOverlap < threshold) continue;
            int startIndex = i;
            int endIndex = i + 1;
            if (inclusionMethod != InclusionMethod.NONE) {
                Set<E> next;
                int j;
                HashSet<E> allOverlapping = new HashSet<E>(bucket);
                Set<E> overlapTarget = inclusionMethod == InclusionMethod.TRANSITIVE ? allOverlapping : bucket;
                for (j = i - 1; j > lastEnd && Overlaps.setsIntersect(next = overlaps.get(j), overlapTarget); --j) {
                    allOverlapping.addAll(next);
                }
                startIndex = j + 1;
                for (j = i + 1; j < regionCount && Overlaps.setsIntersect(next = overlaps.get(j), overlapTarget); ++j) {
                    allOverlapping.addAll(next);
                }
                i = j - 1;
                endIndex = j;
            }
            buckets.add(bucketer.makeBucket(overlaps, startIndex, endIndex));
            lastEnd = i;
        }
        return buckets;
    }

    private static <E> boolean setsIntersect(Set<E> s1, Set<E> s2) {
        for (E s : s1) {
            if (!s2.contains(s)) continue;
            return true;
        }
        return false;
    }

    public static <T> List<T> pullLast(List<T> source, int limit) {
        ArrayList<T> result = new ArrayList<T>(limit);
        while (--limit >= 0) {
            result.add(source.remove(source.size() - 1));
        }
        return result;
    }

    public static <T> Collection<T> pullLastWithOverlapLimit(List<T> allObjectsSorted, List<Set<T>> overlapSets, int limit) {
        int setsCount = overlapSets.size();
        int[] selectedInBucket = new int[setsCount];
        int allCount = allObjectsSorted.size();
        for (int selectedCount = 0; selectedCount < allCount; ++selectedCount) {
            T candidate = allObjectsSorted.get(allCount - 1 - selectedCount);
            for (int i = 0; i < setsCount; ++i) {
                if (!overlapSets.get(i).contains(candidate)) continue;
                int n = i;
                selectedInBucket[n] = selectedInBucket[n] + 1;
                if (selectedInBucket[i] <= limit) continue;
                return Overlaps.pullLast(allObjectsSorted, selectedCount);
            }
        }
        return allObjectsSorted;
    }

    public static interface BucketMaker<E, B> {
        public B makeBucket(List<Set<E>> var1, int var2, int var3);
    }

    public static enum InclusionMethod {
        NONE,
        SINGLE,
        TRANSITIVE;

    }
}

