/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.security;

import flex.messaging.log.Log;
import flex.messaging.security.TomcatLogin;
import flex.messaging.security.TomcatLoginHolder;
import flex.messaging.util.ExceptionUtil;
import java.io.IOException;
import java.security.Principal;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Container;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public class TomcatValve
extends ValveBase
implements Lifecycle {
    private static final String AUTH_TYPE = "flexmessaging";
    private static final String AMF_MATCH = "/amfgateway";
    private static final String GATEWAY_MATCH = "/flashgateway";
    private static final String MESSAGEBROKER_MATCH = "/messagebroker";
    private static String CUSTOM_MATCH = System.getProperty("flex.tomcatValveMatch");

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.invokeServletRequest(request);
        Valve next = this.getNext();
        if (next != null) {
            next.invoke(request, response);
        }
    }

    private void invokeServletRequest(Request request) {
        HttpServletRequest servRequest = request.getRequest();
        if (!(servRequest instanceof HttpServletRequest)) {
            return;
        }
        HttpServletRequest hrequest = servRequest;
        boolean match = this.checkIfPathMatches(hrequest.getServletPath(), hrequest.getRequestURI());
        if (match) {
            this.handleMatch(request, hrequest.getUserPrincipal());
        }
    }

    private void handleMatch(Request request, Principal principal) {
        TomcatLoginHolder.setLogin(new TomcatLoginImpl(this.getContainer(), request));
        if (principal != null) {
            return;
        }
        Session session = TomcatValve.getSession(request, false);
        if (session == null) {
            return;
        }
        principal = session.getPrincipal();
        if (principal != null) {
            request.setAuthType(session.getAuthType());
            request.setUserPrincipal(principal);
        }
    }

    private boolean checkIfPathMatches(String path, String uri) {
        if (path == null) {
            return uri != null && (uri.indexOf(MESSAGEBROKER_MATCH) != -1 || uri.indexOf(AMF_MATCH) != -1 || uri.indexOf(GATEWAY_MATCH) != -1 || CUSTOM_MATCH != null && uri.indexOf(CUSTOM_MATCH) != -1);
        }
        return path.startsWith(MESSAGEBROKER_MATCH) || path.startsWith(AMF_MATCH) || path.startsWith(GATEWAY_MATCH) || CUSTOM_MATCH != null && path.startsWith(CUSTOM_MATCH);
    }

    public void addLifecycleListener(LifecycleListener listener) {
    }

    public LifecycleListener[] findLifecycleListeners() {
        return null;
    }

    public void removeLifecycleListener(LifecycleListener listener) {
    }

    public void start() throws LifecycleException {
        TomcatLoginImpl login = new TomcatLoginImpl(this.getContainer(), null);
        TomcatLoginHolder.setLogin(login);
        TomcatLoginHolder.setNioBasedLogin(login);
    }

    public void stop() throws LifecycleException {
    }

    static Session getSession(Request request, boolean create) {
        HttpServletRequest hreq = request.getRequest();
        HttpSession hses = hreq.getSession(create);
        if (hses == null) {
            return null;
        }
        Manager manager = request.getContext().getManager();
        if (manager == null) {
            return null;
        }
        try {
            return manager.findSession(hses.getId());
        }
        catch (IOException e) {
            Log.getLogger((String)"Security").error("Error in TomcatValve getting session id " + hses.getId() + " : " + ExceptionUtil.toString((Throwable)e));
            return null;
        }
    }

    class TomcatLoginImpl
    implements TomcatLogin {
        private Container container;
        private Request request;

        TomcatLoginImpl(Container container, Request request) {
            this.container = container;
            this.request = request;
        }

        @Override
        public Principal login(String username, String password, HttpServletRequest servletRequest) {
            Realm realm = this.container.getRealm();
            if (realm == null) {
                return null;
            }
            Principal principal = realm.authenticate(username, password);
            if (principal == null) {
                return null;
            }
            if (this.servletRequestMatches(servletRequest)) {
                this.request.setAuthType(TomcatValve.AUTH_TYPE);
                this.request.setUserPrincipal(principal);
                Session session = TomcatValve.getSession(this.request, true);
                if (session != null) {
                    session.setAuthType(TomcatValve.AUTH_TYPE);
                    session.setPrincipal(principal);
                    if (username != null) {
                        session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
                    } else {
                        session.removeNote("org.apache.catalina.session.USERNAME");
                    }
                    if (password != null) {
                        session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
                    } else {
                        session.removeNote("org.apache.catalina.session.PASSWORD");
                    }
                }
            }
            return principal;
        }

        @Override
        public boolean authorize(Principal principal, List roles) {
            Realm realm = this.container.getRealm();
            for (String role : roles) {
                if (!realm.hasRole(principal, role)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean logout(HttpServletRequest servletRequest) {
            if (this.servletRequestMatches(servletRequest)) {
                Session session = TomcatValve.getSession(this.request, false);
                if (session != null) {
                    session.setPrincipal(null);
                    session.setAuthType(null);
                    session.removeNote("org.apache.catalina.session.USERNAME");
                    session.removeNote("org.apache.catalina.session.PASSWORD");
                }
                return true;
            }
            return false;
        }

        private boolean servletRequestMatches(HttpServletRequest servletRequest) {
            return this.request != null && this.request.getRequest() == servletRequest;
        }

        @Override
        public Principal convertPrincipal(Principal principal) {
            return principal;
        }
    }
}

