/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.table;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.io.DefaultInputSplitAssigner;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.jdbc.JdbcConnectionOptions;
import org.apache.flink.connector.jdbc.converter.JdbcRowConverter;
import org.apache.flink.connector.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.connection.SimpleJdbcConnectionProvider;
import org.apache.flink.connector.jdbc.split.JdbcParameterValuesProvider;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class JdbcRowDataInputFormat
extends RichInputFormat<RowData, InputSplit>
implements ResultTypeQueryable<RowData> {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(JdbcRowDataInputFormat.class);
    private JdbcConnectionProvider connectionProvider;
    private int fetchSize;
    private Boolean autoCommit;
    private Object[][] parameterValues;
    private String queryTemplate;
    private int resultSetType;
    private int resultSetConcurrency;
    private JdbcRowConverter rowConverter;
    private TypeInformation<RowData> rowDataTypeInfo;
    private transient PreparedStatement statement;
    private transient ResultSet resultSet;
    private transient boolean hasNext;

    private JdbcRowDataInputFormat(JdbcConnectionProvider connectionProvider, int fetchSize, Boolean autoCommit, Object[][] parameterValues, String queryTemplate, int resultSetType, int resultSetConcurrency, JdbcRowConverter rowConverter, TypeInformation<RowData> rowDataTypeInfo) {
        this.connectionProvider = connectionProvider;
        this.fetchSize = fetchSize;
        this.autoCommit = autoCommit;
        this.parameterValues = parameterValues;
        this.queryTemplate = queryTemplate;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.rowConverter = rowConverter;
        this.rowDataTypeInfo = rowDataTypeInfo;
    }

    public void configure(Configuration parameters) {
    }

    public void openInputFormat() {
        try {
            Connection dbConn = this.connectionProvider.getOrEstablishConnection();
            if (this.autoCommit != null) {
                dbConn.setAutoCommit(this.autoCommit);
            }
            this.statement = dbConn.prepareStatement(this.queryTemplate, this.resultSetType, this.resultSetConcurrency);
            if (this.fetchSize == Integer.MIN_VALUE || this.fetchSize > 0) {
                this.statement.setFetchSize(this.fetchSize);
            }
        }
        catch (SQLException se) {
            throw new IllegalArgumentException("open() failed." + se.getMessage(), se);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalArgumentException("JDBC-Class not found. - " + cnfe.getMessage(), cnfe);
        }
    }

    public void closeInputFormat() {
        try {
            if (this.statement != null) {
                this.statement.close();
            }
        }
        catch (SQLException se) {
            LOG.info("Inputformat Statement couldn't be closed - " + se.getMessage());
        }
        finally {
            this.statement = null;
        }
        this.connectionProvider.closeConnection();
        this.parameterValues = null;
    }

    public void open(InputSplit inputSplit) throws IOException {
        try {
            if (inputSplit != null && this.parameterValues != null) {
                for (int i = 0; i < this.parameterValues[inputSplit.getSplitNumber()].length; ++i) {
                    Object param = this.parameterValues[inputSplit.getSplitNumber()][i];
                    if (param instanceof String) {
                        this.statement.setString(i + 1, (String)param);
                        continue;
                    }
                    if (param instanceof Long) {
                        this.statement.setLong(i + 1, (Long)param);
                        continue;
                    }
                    if (param instanceof Integer) {
                        this.statement.setInt(i + 1, (Integer)param);
                        continue;
                    }
                    if (param instanceof Double) {
                        this.statement.setDouble(i + 1, (Double)param);
                        continue;
                    }
                    if (param instanceof Boolean) {
                        this.statement.setBoolean(i + 1, (Boolean)param);
                        continue;
                    }
                    if (param instanceof Float) {
                        this.statement.setFloat(i + 1, ((Float)param).floatValue());
                        continue;
                    }
                    if (param instanceof BigDecimal) {
                        this.statement.setBigDecimal(i + 1, (BigDecimal)param);
                        continue;
                    }
                    if (param instanceof Byte) {
                        this.statement.setByte(i + 1, (Byte)param);
                        continue;
                    }
                    if (param instanceof Short) {
                        this.statement.setShort(i + 1, (Short)param);
                        continue;
                    }
                    if (param instanceof Date) {
                        this.statement.setDate(i + 1, (Date)param);
                        continue;
                    }
                    if (param instanceof Time) {
                        this.statement.setTime(i + 1, (Time)param);
                        continue;
                    }
                    if (param instanceof Timestamp) {
                        this.statement.setTimestamp(i + 1, (Timestamp)param);
                        continue;
                    }
                    if (param instanceof Array) {
                        this.statement.setArray(i + 1, (Array)param);
                        continue;
                    }
                    throw new IllegalArgumentException("open() failed. Parameter " + i + " of type " + param.getClass() + " is not handled (yet).");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Executing '%s' with parameters %s", this.queryTemplate, Arrays.deepToString(this.parameterValues[inputSplit.getSplitNumber()])));
                }
            }
            this.resultSet = this.statement.executeQuery();
            this.hasNext = this.resultSet.next();
        }
        catch (SQLException se) {
            throw new IllegalArgumentException("open() failed." + se.getMessage(), se);
        }
    }

    public void close() throws IOException {
        if (this.resultSet == null) {
            return;
        }
        try {
            this.resultSet.close();
        }
        catch (SQLException se) {
            LOG.info("Inputformat ResultSet couldn't be closed - " + se.getMessage());
        }
    }

    public TypeInformation<RowData> getProducedType() {
        return this.rowDataTypeInfo;
    }

    public boolean reachedEnd() throws IOException {
        return !this.hasNext;
    }

    public RowData nextRecord(RowData reuse) throws IOException {
        try {
            if (!this.hasNext) {
                return null;
            }
            RowData row = this.rowConverter.toInternal(this.resultSet);
            this.hasNext = this.resultSet.next();
            return row;
        }
        catch (SQLException se) {
            throw new IOException("Couldn't read data - " + se.getMessage(), se);
        }
        catch (NullPointerException npe) {
            throw new IOException("Couldn't access resultSet", npe);
        }
    }

    public BaseStatistics getStatistics(BaseStatistics cachedStatistics) throws IOException {
        return cachedStatistics;
    }

    public InputSplit[] createInputSplits(int minNumSplits) throws IOException {
        if (this.parameterValues == null) {
            return new GenericInputSplit[]{new GenericInputSplit(0, 1)};
        }
        GenericInputSplit[] ret = new GenericInputSplit[this.parameterValues.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new GenericInputSplit(i, ret.length);
        }
        return ret;
    }

    public InputSplitAssigner getInputSplitAssigner(InputSplit[] inputSplits) {
        return new DefaultInputSplitAssigner(inputSplits);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private JdbcConnectionOptions.JdbcConnectionOptionsBuilder connOptionsBuilder = new JdbcConnectionOptions.JdbcConnectionOptionsBuilder();
        private int fetchSize;
        private Boolean autoCommit;
        private Object[][] parameterValues;
        private String queryTemplate;
        private JdbcRowConverter rowConverter;
        private TypeInformation<RowData> rowDataTypeInfo;
        private int resultSetType = 1003;
        private int resultSetConcurrency = 1007;

        public Builder setDrivername(String drivername) {
            this.connOptionsBuilder.withDriverName(drivername);
            return this;
        }

        public Builder setDBUrl(String dbURL) {
            this.connOptionsBuilder.withUrl(dbURL);
            return this;
        }

        public Builder setUsername(String username) {
            this.connOptionsBuilder.withUsername(username);
            return this;
        }

        public Builder setPassword(String password) {
            this.connOptionsBuilder.withPassword(password);
            return this;
        }

        public Builder setQuery(String query) {
            this.queryTemplate = query;
            return this;
        }

        public Builder setParametersProvider(JdbcParameterValuesProvider parameterValuesProvider) {
            this.parameterValues = parameterValuesProvider.getParameterValues();
            return this;
        }

        public Builder setRowDataTypeInfo(TypeInformation<RowData> rowDataTypeInfo) {
            this.rowDataTypeInfo = rowDataTypeInfo;
            return this;
        }

        public Builder setRowConverter(JdbcRowConverter rowConverter) {
            this.rowConverter = rowConverter;
            return this;
        }

        public Builder setFetchSize(int fetchSize) {
            Preconditions.checkArgument((fetchSize == Integer.MIN_VALUE || fetchSize > 0 ? 1 : 0) != 0, (String)"Illegal value %s for fetchSize, has to be positive or Integer.MIN_VALUE.", (Object[])new Object[]{fetchSize});
            this.fetchSize = fetchSize;
            return this;
        }

        public Builder setAutoCommit(boolean autoCommit) {
            this.autoCommit = autoCommit;
            return this;
        }

        public Builder setResultSetType(int resultSetType) {
            this.resultSetType = resultSetType;
            return this;
        }

        public Builder setResultSetConcurrency(int resultSetConcurrency) {
            this.resultSetConcurrency = resultSetConcurrency;
            return this;
        }

        public JdbcRowDataInputFormat build() {
            if (this.queryTemplate == null) {
                throw new NullPointerException("No query supplied");
            }
            if (this.rowConverter == null) {
                throw new NullPointerException("No row converter supplied");
            }
            if (this.parameterValues == null) {
                LOG.debug("No input splitting configured (data will be read with parallelism 1).");
            }
            return new JdbcRowDataInputFormat(new SimpleJdbcConnectionProvider(this.connOptionsBuilder.build()), this.fetchSize, this.autoCommit, this.parameterValues, this.queryTemplate, this.resultSetType, this.resultSetConcurrency, this.rowConverter, this.rowDataTypeInfo);
        }
    }
}

