/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.sink;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.flink.connector.kafka.sink.KafkaWriterState;
import org.apache.flink.core.io.SimpleVersionedSerializer;

class KafkaWriterStateSerializer
implements SimpleVersionedSerializer<KafkaWriterState> {
    KafkaWriterStateSerializer() {
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(KafkaWriterState state) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream out = new DataOutputStream(baos);){
                out.writeUTF(state.getTransactionalIdPrefix());
                out.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public KafkaWriterState deserialize(int version, byte[] serialized) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
            KafkaWriterState kafkaWriterState;
            try (DataInputStream in = new DataInputStream(bais);){
                String transactionalIdPrefx = in.readUTF();
                kafkaWriterState = new KafkaWriterState(transactionalIdPrefx);
            }
            return kafkaWriterState;
        }
    }
}

