/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.config;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.pulsar.common.config.PulsarConfigValidator;
import org.apache.flink.connector.pulsar.common.config.PulsarConfiguration;
import org.apache.flink.util.Preconditions;

@Internal
public final class PulsarConfigBuilder {
    private final Configuration configuration = new Configuration();

    public <T> boolean contains(ConfigOption<T> option) {
        return this.configuration.contains(option);
    }

    public <T> T get(ConfigOption<T> key) {
        return (T)this.configuration.get(key);
    }

    public <T> void set(ConfigOption<T> option, T value) {
        Preconditions.checkNotNull(option);
        Preconditions.checkNotNull(value);
        if (this.configuration.contains(option)) {
            Object oldValue = this.configuration.get(option);
            Preconditions.checkArgument((boolean)Objects.equals(oldValue, value), (String)"This option %s has been set to value %s.", (Object[])new Object[]{option.key(), oldValue});
        } else {
            this.configuration.set(option, value);
        }
    }

    public void set(Configuration config) {
        Map existedConfigs = this.configuration.toMap();
        ArrayList<String> duplicatedKeys = new ArrayList<String>();
        for (Map.Entry entry : config.toMap().entrySet()) {
            String value2;
            String key = (String)entry.getKey();
            if (!existedConfigs.containsKey(key) || Objects.equals(value2 = (String)existedConfigs.get(key), entry.getValue())) continue;
            duplicatedKeys.add(key);
        }
        Preconditions.checkArgument((boolean)duplicatedKeys.isEmpty(), (String)"Invalid configuration, these keys %s are already exist with different config value.", (Object[])new Object[]{duplicatedKeys});
        this.configuration.addAll(config);
    }

    public void set(Properties properties) {
        properties.keySet().stream().map(String::valueOf).forEach(key -> {
            ConfigOption option = ConfigOptions.key((String)key).stringType().noDefaultValue();
            Object value = properties.get(key);
            if (value != null) {
                this.set(option, value.toString());
            }
        });
    }

    public <T> void override(ConfigOption<T> option, T value) {
        Preconditions.checkNotNull(option);
        Preconditions.checkNotNull(value);
        this.configuration.set(option, value);
    }

    public <T extends PulsarConfiguration> T build(PulsarConfigValidator validator, Function<Configuration, T> constructor) {
        validator.validate(this.configuration);
        return (T)((Object)((PulsarConfiguration)((Object)constructor.apply(this.configuration))));
    }
}

