/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.cursor.stop;

import java.util.Objects;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.impl.schema.AutoConsumeSchema;

public class LatestMessageStopCursor
implements StopCursor {
    private static final long serialVersionUID = 1702059838323965723L;
    private static final String SUBSCRIPTION_NAME = LatestMessageStopCursor.class.getSimpleName();
    private MessageId messageId;
    private final boolean inclusive;

    public LatestMessageStopCursor(boolean inclusive) {
        this.inclusive = inclusive;
    }

    @Override
    public StopCursor.StopCondition shouldStop(Message<?> message) {
        MessageId current = message.getMessageId();
        return StopCursor.StopCondition.compare(this.messageId, current, this.inclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(PulsarClient client, TopicPartition partition) throws PulsarClientException {
        if (this.messageId == null) {
            Consumer<GenericRecord> consumer = null;
            try {
                consumer = client.newConsumer(new AutoConsumeSchema()).topic(partition.getFullTopicName()).subscriptionName(SUBSCRIPTION_NAME).subscribe();
                this.messageId = consumer.getLastMessageId();
            }
            finally {
                if (consumer != null) {
                    consumer.unsubscribe();
                    consumer.close();
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LatestMessageStopCursor that = (LatestMessageStopCursor)o;
        return this.inclusive == that.inclusive && Objects.equals(this.messageId, that.messageId);
    }

    public int hashCode() {
        return Objects.hash(this.messageId, this.inclusive);
    }
}

