/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.bouncycastle.math.ec.endo;

import java.math.BigInteger;
import org.apache.pulsar.shade.org.bouncycastle.math.ec.ECCurve;
import org.apache.pulsar.shade.org.bouncycastle.math.ec.ECPointMap;
import org.apache.pulsar.shade.org.bouncycastle.math.ec.ScaleYNegateXPointMap;
import org.apache.pulsar.shade.org.bouncycastle.math.ec.endo.EndoUtil;
import org.apache.pulsar.shade.org.bouncycastle.math.ec.endo.GLVEndomorphism;
import org.apache.pulsar.shade.org.bouncycastle.math.ec.endo.GLVTypeAParameters;

public class GLVTypeAEndomorphism
implements GLVEndomorphism {
    protected final GLVTypeAParameters parameters;
    protected final ECPointMap pointMap;

    public GLVTypeAEndomorphism(ECCurve eCCurve, GLVTypeAParameters gLVTypeAParameters) {
        this.parameters = gLVTypeAParameters;
        this.pointMap = new ScaleYNegateXPointMap(eCCurve.fromBigInteger(gLVTypeAParameters.getI()));
    }

    public BigInteger[] decomposeScalar(BigInteger bigInteger) {
        return EndoUtil.decomposeScalar(this.parameters.getSplitParams(), bigInteger);
    }

    public ECPointMap getPointMap() {
        return this.pointMap;
    }

    public boolean hasEfficientPointMap() {
        return true;
    }
}

