/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.web.resources;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.namenode.web.resources.NamenodeWebHdfsMethods;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class TestWebHdfsDataLocality {
    static final Log LOG = LogFactory.getLog(TestWebHdfsDataLocality.class);
    private static final String RACK0 = "/rack0";
    private static final String RACK1 = "/rack1";
    private static final String RACK2 = "/rack2";
    private static final String LOCALHOST = InetAddress.getLoopbackAddress().getHostName();
    @Rule
    public final ExpectedException exception;

    public TestWebHdfsDataLocality() {
        DFSTestUtil.setNameNodeLogLevel(Level.ALL);
        this.exception = ExpectedException.none();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataLocality() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        String[] racks = new String[]{RACK0, RACK0, RACK1, RACK1, RACK2, RACK2};
        int nDataNodes = racks.length;
        LOG.info((Object)("nDataNodes=" + nDataNodes + ", racks=" + Arrays.asList(racks)));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(nDataNodes).racks(racks).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            NameNode namenode = cluster.getNameNode();
            DatanodeManager dm = namenode.getNamesystem().getBlockManager().getDatanodeManager();
            LOG.info((Object)("dm=" + dm));
            long blocksize = 0x8000000L;
            String f = "/foo";
            for (int i = 0; i < nDataNodes; ++i) {
                DataNode dn = cluster.getDataNodes().get(i);
                String ipAddr = dm.getDatanode(dn.getDatanodeId()).getIpAddr();
                DatanodeInfo chosen = NamenodeWebHdfsMethods.chooseDatanode((NameNode)namenode, (String)"/foo", (HttpOpParam.Op)PutOpParam.Op.CREATE, (long)-1L, (long)0x8000000L, null, (String)LOCALHOST);
                Assert.assertEquals((Object)ipAddr, (Object)chosen.getIpAddr());
            }
            Path p = new Path("/foo");
            FSDataOutputStream out = dfs.create(p, (short)1);
            out.write(1);
            out.close();
            LocatedBlocks locatedblocks = NameNodeAdapter.getBlockLocations(namenode, "/foo", 0L, 1L);
            List lb = locatedblocks.getLocatedBlocks();
            Assert.assertEquals((long)1L, (long)lb.size());
            DatanodeInfo[] locations = ((LocatedBlock)lb.get(0)).getLocations();
            Assert.assertEquals((long)1L, (long)locations.length);
            DatanodeInfo expected = locations[0];
            DatanodeInfo chosen = NamenodeWebHdfsMethods.chooseDatanode((NameNode)namenode, (String)"/foo", (HttpOpParam.Op)GetOpParam.Op.GETFILECHECKSUM, (long)-1L, (long)0x8000000L, null, (String)LOCALHOST);
            Assert.assertEquals((Object)expected, (Object)chosen);
            chosen = NamenodeWebHdfsMethods.chooseDatanode((NameNode)namenode, (String)"/foo", (HttpOpParam.Op)GetOpParam.Op.OPEN, (long)0L, (long)0x8000000L, null, (String)LOCALHOST);
            Assert.assertEquals((Object)expected, (Object)chosen);
            chosen = NamenodeWebHdfsMethods.chooseDatanode((NameNode)namenode, (String)"/foo", (HttpOpParam.Op)PostOpParam.Op.APPEND, (long)-1L, (long)0x8000000L, null, (String)LOCALHOST);
            Assert.assertEquals((Object)expected, (Object)chosen);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExcludeDataNodes() throws Exception {
        Configuration conf = WebHdfsTestUtil.createConf();
        String[] racks = new String[]{RACK0, RACK0, RACK1, RACK1, RACK2, RACK2};
        String[] hosts = new String[]{"DataNode1", "DataNode2", "DataNode3", "DataNode4", "DataNode5", "DataNode6"};
        int nDataNodes = hosts.length;
        LOG.info((Object)("nDataNodes=" + nDataNodes + ", racks=" + Arrays.asList(racks) + ", hosts=" + Arrays.asList(hosts)));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).hosts(hosts).numDataNodes(nDataNodes).racks(racks).build();
        try {
            cluster.waitActive();
            DistributedFileSystem dfs = cluster.getFileSystem();
            NameNode namenode = cluster.getNameNode();
            DatanodeManager dm = namenode.getNamesystem().getBlockManager().getDatanodeManager();
            LOG.info((Object)("dm=" + dm));
            long blocksize = 0x8000000L;
            String f = "/foo";
            Path p = new Path("/foo");
            FSDataOutputStream out = dfs.create(p, (short)3);
            out.write(1);
            out.close();
            LocatedBlocks locatedblocks = NameNodeAdapter.getBlockLocations(namenode, "/foo", 0L, 1L);
            List lb = locatedblocks.getLocatedBlocks();
            Assert.assertEquals((long)1L, (long)lb.size());
            DatanodeInfo[] locations = ((LocatedBlock)lb.get(0)).getLocations();
            Assert.assertEquals((long)3L, (long)locations.length);
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < 2; ++i) {
                int j;
                sb.append(locations[i].getXferAddr());
                DatanodeInfo chosen = NamenodeWebHdfsMethods.chooseDatanode((NameNode)namenode, (String)"/foo", (HttpOpParam.Op)GetOpParam.Op.GETFILECHECKSUM, (long)-1L, (long)0x8000000L, (String)sb.toString(), (String)LOCALHOST);
                for (j = 0; j <= i; ++j) {
                    Assert.assertNotEquals((Object)locations[j].getHostName(), (Object)chosen.getHostName());
                }
                chosen = NamenodeWebHdfsMethods.chooseDatanode((NameNode)namenode, (String)"/foo", (HttpOpParam.Op)GetOpParam.Op.OPEN, (long)0L, (long)0x8000000L, (String)sb.toString(), (String)LOCALHOST);
                for (j = 0; j <= i; ++j) {
                    Assert.assertNotEquals((Object)locations[j].getHostName(), (Object)chosen.getHostName());
                }
                chosen = NamenodeWebHdfsMethods.chooseDatanode((NameNode)namenode, (String)"/foo", (HttpOpParam.Op)PostOpParam.Op.APPEND, (long)-1L, (long)0x8000000L, (String)sb.toString(), (String)LOCALHOST);
                for (j = 0; j <= i; ++j) {
                    Assert.assertNotEquals((Object)locations[j].getHostName(), (Object)chosen.getHostName());
                }
                sb.append(",");
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    public void testChooseDatanodeBeforeNamesystemInit() throws Exception {
        NameNode nn = (NameNode)Mockito.mock(NameNode.class);
        Mockito.when((Object)nn.getNamesystem()).thenReturn(null);
        this.exception.expect(IOException.class);
        this.exception.expectMessage("Namesystem has not been intialized yet.");
        NamenodeWebHdfsMethods.chooseDatanode((NameNode)nn, (String)"/path", (HttpOpParam.Op)PutOpParam.Op.CREATE, (long)0L, (long)0x8000000L, null, (String)LOCALHOST);
    }
}

