/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.netty.implementation.NettyToAzureCoreHttpHeadersWrapper;
import com.azure.core.implementation.util.HttpHeadersAccessHelper;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.azure.shaded.io.netty.util.AsciiString;
import reactor.netty.http.client.HttpClientResponse;

public abstract class NettyAsyncHttpResponseBase
extends HttpResponse {
    private final HttpClientResponse reactorNettyResponse;
    private final HttpHeaders headers;

    NettyAsyncHttpResponseBase(HttpClientResponse reactorNettyResponse, HttpRequest httpRequest, boolean headersEagerlyConverted) {
        super(httpRequest);
        this.reactorNettyResponse = reactorNettyResponse;
        org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpHeaders nettyHeaders = reactorNettyResponse.responseHeaders();
        if (headersEagerlyConverted) {
            this.headers = new HttpHeaders((int)((float)nettyHeaders.size() / 0.75f));
            Iterator<Map.Entry<CharSequence, CharSequence>> nettyHeadersIterator = nettyHeaders.iteratorCharSequence();
            while (nettyHeadersIterator.hasNext()) {
                Map.Entry<CharSequence, CharSequence> next = nettyHeadersIterator.next();
                String value = Objects.toString(next.getValue(), null);
                CharSequence key = next.getKey();
                if (key instanceof AsciiString) {
                    AsciiString asciiString = (AsciiString)key;
                    HttpHeadersAccessHelper.addInternal(this.headers, asciiString.toLowerCase().toString(), asciiString.toString(), value);
                    continue;
                }
                this.headers.add(key.toString(), value);
            }
        } else {
            this.headers = new NettyToAzureCoreHttpHeadersWrapper(nettyHeaders);
        }
    }

    @Override
    public final int getStatusCode() {
        return this.reactorNettyResponse.status().code();
    }

    @Override
    @Deprecated
    public final String getHeaderValue(String name) {
        return this.headers.getValue(name);
    }

    @Override
    public final String getHeaderValue(HttpHeaderName headerName) {
        return this.headers.getValue(headerName);
    }

    @Override
    public final HttpHeaders getHeaders() {
        return this.headers;
    }
}

