/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.iceberg.azure.shaded.io.netty.util.concurrent.ScheduledFuture;

public final class ResponseTimeoutHandler
extends ChannelInboundHandlerAdapter {
    public static final String HANDLER_NAME = "azureResponseTimeoutHandler";
    private static final String RESPONSE_TIMED_OUT_MESSAGE = "Channel response timed out after %d milliseconds.";
    private final long timeoutMillis;
    private boolean closed;
    private ScheduledFuture<?> responseTimeoutWatcher;

    public ResponseTimeoutHandler(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    ScheduledFuture<?> getResponseTimeoutWatcher() {
        return this.responseTimeoutWatcher;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        if (this.timeoutMillis > 0L) {
            this.responseTimeoutWatcher = ctx.executor().schedule(() -> this.responseTimedOut(ctx), this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.disposeWatcher();
    }

    void responseTimedOut(ChannelHandlerContext ctx) {
        if (!this.closed) {
            this.disposeWatcher();
            ctx.fireExceptionCaught(new TimeoutException(String.format(RESPONSE_TIMED_OUT_MESSAGE, this.timeoutMillis)));
            ctx.close();
            this.closed = true;
        }
    }

    private void disposeWatcher() {
        if (this.responseTimeoutWatcher != null && !this.responseTimeoutWatcher.isDone()) {
            this.responseTimeoutWatcher.cancel(false);
            this.responseTimeoutWatcher = null;
        }
    }
}

