/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.implementation.ReflectionSerializable;
import com.azure.core.implementation.jackson.JacksonJsonWriter;
import com.azure.json.JsonSerializable;
import java.io.IOException;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.BeanDescription;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.Module;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.SerializationConfig;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;

final class JsonSerializableSerializer
extends JsonSerializer<JsonSerializable> {
    JsonSerializableSerializer() {
    }

    public static Module getModule() {
        return new SimpleModule().setSerializerModifier(new BeanSerializerModifier(){

            @Override
            public BeanSerializerBuilder updateBuilder(SerializationConfig config, BeanDescription beanDesc, BeanSerializerBuilder builder) {
                if (ReflectionSerializable.supportsJsonSerializable(beanDesc.getBeanClass())) {
                    return new BeanSerializerBuilder(beanDesc){

                        @Override
                        public JsonSerializer<?> build() {
                            return new JsonSerializableSerializer();
                        }
                    };
                }
                return builder;
            }

            @Override
            public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                return ReflectionSerializable.supportsJsonSerializable(beanDesc.getBeanClass()) ? new JsonSerializableSerializer() : serializer;
            }
        });
    }

    @Override
    public void serialize(JsonSerializable value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        new JacksonJsonWriter(gen).writeJson(value);
    }

    @Override
    public Class<JsonSerializable> handledType() {
        return JsonSerializable.class;
    }
}

