/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.credential.AccessToken;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;

public final class MSIToken
extends AccessToken {
    private static final ClientLogger LOGGER = new ClientLogger(MSIToken.class);
    private static final OffsetDateTime EPOCH = OffsetDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
    private static final DateTimeFormatter DTF = DateTimeFormatter.ofPattern("M/d/yyyy H:mm:ss XXX").withLocale(Locale.US);
    private static final DateTimeFormatter DTF_WINDOWS = DateTimeFormatter.ofPattern("M/d/yyyy h:mm:ss a XXX").withLocale(Locale.US);
    private final String accessToken;

    public MSIToken(String token, String expiresOn, String expiresIn) {
        super(token, EPOCH.plusSeconds(MSIToken.parseToEpochSeconds(expiresOn, expiresIn)), MSIToken.inferManagedIdentityRefreshInValue(EPOCH.plusSeconds(MSIToken.parseToEpochSeconds(expiresOn, expiresIn))));
        this.accessToken = token;
    }

    @Override
    public String getToken() {
        return this.accessToken;
    }

    public static MSIToken fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String accessToken = null;
            String expiresOn = null;
            String expiresIn = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("access_token".equals(fieldName)) {
                    accessToken = reader.getString();
                    continue;
                }
                if ("expires_on".equals(fieldName)) {
                    expiresOn = reader.getString();
                    continue;
                }
                if ("expires_in".equals(fieldName)) {
                    expiresIn = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new MSIToken(accessToken, expiresOn, expiresIn);
        });
    }

    private static Long parseToEpochSeconds(String expiresOn, String expiresIn) {
        boolean isExpiresOn = !CoreUtils.isNullOrEmpty(expiresOn);
        String dateToParse = isExpiresOn ? expiresOn : expiresIn;
        try {
            long seconds = Long.parseLong(dateToParse);
            if (isExpiresOn) {
                return seconds;
            }
            return OffsetDateTime.now(ZoneOffset.UTC).plusSeconds(seconds).toEpochSecond();
        }
        catch (NumberFormatException e) {
            LOGGER.verbose(e.getMessage());
            try {
                return Instant.from(DTF.parse(dateToParse)).getEpochSecond();
            }
            catch (DateTimeParseException e2) {
                LOGGER.verbose(e2.getMessage());
                try {
                    return Instant.from(DTF_WINDOWS.parse(dateToParse)).getEpochSecond();
                }
                catch (DateTimeParseException e3) {
                    LOGGER.verbose(e3.getMessage());
                    throw LOGGER.logExceptionAsError(new IllegalArgumentException("Unable to parse date time " + dateToParse));
                }
            }
        }
    }

    private static OffsetDateTime inferManagedIdentityRefreshInValue(OffsetDateTime expiresOn) {
        OffsetDateTime now = OffsetDateTime.now(ZoneOffset.UTC);
        if (expiresOn.isAfter(now.plus(Duration.ofHours(2L)))) {
            Duration duration = Duration.between(now, expiresOn);
            return expiresOn.minus(duration.dividedBy(2L));
        }
        return null;
    }
}

