/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.storage.common.StorageSharedKeyCredential;
import reactor.core.publisher.Mono;

public final class StorageSharedKeyCredentialPolicy
implements HttpPipelinePolicy {
    private final StorageSharedKeyCredential credential;

    public StorageSharedKeyCredentialPolicy(StorageSharedKeyCredential credential) {
        this.credential = credential;
    }

    public StorageSharedKeyCredential sharedKeyCredential() {
        return this.credential;
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        this.setAuthorizationHeader(context);
        return next.processSync();
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        this.setAuthorizationHeader(context);
        return next.process();
    }

    private void setAuthorizationHeader(HttpPipelineCallContext context) {
        String authorizationValue = this.credential.generateAuthorizationHeader(context.getHttpRequest().getUrl(), context.getHttpRequest().getHttpMethod().toString(), context.getHttpRequest().getHeaders(), Boolean.TRUE.equals(context.getData("Azure-Storage-Log-String-To-Sign").orElse(false)));
        context.getHttpRequest().setHeader("Authorization", authorizationValue);
    }
}

