/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.http;

import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.ReadOnlyHTTPMessage;
import com.nimbusds.oauth2.sdk.util.ContentTypeUtils;
import com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

abstract class HTTPMessage
implements ReadOnlyHTTPMessage {
    private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private String body;
    private String clientIPAddress;

    HTTPMessage() {
    }

    public ContentType getEntityContentType() {
        String value = this.getHeaderValue("Content-Type");
        if (value == null) {
            return null;
        }
        try {
            return ContentType.parse(value);
        }
        catch (java.text.ParseException e) {
            return null;
        }
    }

    public void setEntityContentType(ContentType ct) {
        this.setHeader("Content-Type", ct != null ? ct.toString() : null);
    }

    public void setContentType(String ct) throws ParseException {
        try {
            this.setHeader("Content-Type", ct != null ? ContentType.parse(ct).toString() : null);
        }
        catch (java.text.ParseException e) {
            throw new ParseException("Invalid Content-Type value: " + e.getMessage());
        }
    }

    public void ensureEntityContentType() throws ParseException {
        if (this.getEntityContentType() == null) {
            throw new ParseException("Missing HTTP Content-Type header");
        }
    }

    public void ensureEntityContentType(ContentType contentType) throws ParseException {
        ContentTypeUtils.ensureContentType(contentType, this.getEntityContentType());
    }

    public void ensureEntityContentType(ContentType contentType, String subTypeSuffix) throws ParseException {
        ContentTypeUtils.ensureContentType(contentType, subTypeSuffix, this.getEntityContentType());
    }

    public String getHeaderValue(String name) {
        return MultivaluedMapUtils.getFirstValue(this.headers, name);
    }

    public List<String> getHeaderValues(String name) {
        return this.headers.get(name);
    }

    public void setHeader(String name, String ... values) {
        if (values != null && values.length > 0) {
            this.headers.put(name, Arrays.asList(values));
        } else {
            this.headers.remove(name);
        }
    }

    @Override
    public Map<String, List<String>> getHeaderMap() {
        return this.headers;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    private void ensureBody() throws ParseException {
        if (this.getBody() == null || this.getBody().isEmpty()) {
            throw new ParseException("Missing or empty HTTP message body");
        }
    }

    public Map<String, List<String>> getBodyAsFormParameters() throws ParseException {
        this.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
        if (StringUtils.isBlank(this.getBody())) {
            return Collections.emptyMap();
        }
        return URLUtils.parseParameters(this.getBody());
    }

    public JSONObject getBodyAsJSONObject() throws ParseException {
        this.ensureEntityContentType(ContentType.APPLICATION_JSON, "json");
        this.ensureBody();
        return JSONObjectUtils.parse(this.getBody());
    }

    public JSONArray getBodyAsJSONArray() throws ParseException {
        this.ensureEntityContentType(ContentType.APPLICATION_JSON, "json");
        this.ensureBody();
        return JSONArrayUtils.parse(this.getBody());
    }

    public JWT getBodyAsJWT() throws ParseException {
        this.ensureEntityContentType(ContentType.APPLICATION_JWT, "jwt");
        this.ensureBody();
        try {
            return JWTParser.parse(this.getBody());
        }
        catch (java.text.ParseException e) {
            throw new ParseException(e.getMessage(), e);
        }
    }

    public String getClientIPAddress() {
        return this.clientIPAddress;
    }

    public void setClientIPAddress(String clientIPAddress) {
        this.clientIPAddress = clientIPAddress;
    }
}

