/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpHeaders;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.cookie.Cookie;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import reactor.netty.http.Cookies;

public final class ServerCookies
extends Cookies {
    final ServerCookieDecoder serverCookieDecoder;
    Map<CharSequence, List<Cookie>> allCachedCookies;

    public static ServerCookies newServerRequestHolder(HttpHeaders headers, ServerCookieDecoder decoder) {
        return new ServerCookies(headers, (CharSequence)HttpHeaderNames.COOKIE, false, decoder);
    }

    ServerCookies(HttpHeaders nettyHeaders, CharSequence cookiesHeaderName, boolean isClientChannel, ServerCookieDecoder decoder) {
        super(nettyHeaders, cookiesHeaderName, isClientChannel, decoder);
        this.serverCookieDecoder = decoder;
        this.allCachedCookies = Collections.emptyMap();
    }

    @Override
    public Map<CharSequence, Set<Cookie>> getCachedCookies() {
        this.getAllCachedCookies();
        return this.cachedCookies;
    }

    public Map<CharSequence, List<Cookie>> getAllCachedCookies() {
        if (!this.markReadingCookies()) {
            while (!this.hasReadCookies()) {
            }
            return this.allCachedCookies;
        }
        List<String> allCookieHeaders = this.allCookieHeaders();
        HashMap<String, Set> cookies = new HashMap<String, Set>();
        HashMap<String, List> allCookies = new HashMap<String, List>();
        for (String aCookieHeader : allCookieHeaders) {
            List<Cookie> decode = this.serverCookieDecoder.decodeAll(aCookieHeader);
            for (Cookie cookie : decode) {
                Set existingCookiesOfNameSet = cookies.computeIfAbsent(cookie.name(), k -> new HashSet());
                existingCookiesOfNameSet.add(cookie);
                List existingCookiesOfNameList = allCookies.computeIfAbsent(cookie.name(), k -> new ArrayList());
                existingCookiesOfNameList.add(cookie);
            }
        }
        this.cachedCookies = Collections.unmodifiableMap(cookies);
        this.allCachedCookies = Collections.unmodifiableMap(allCookies);
        this.markReadCookies();
        return this.allCachedCookies;
    }
}

