/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.rpc.RequestMutator;
import com.google.api.gax.rpc.RequestParamsExtractor;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.TypeRegistry;

public class HttpJsonCallSettings<RequestT, ResponseT> {
    private final ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor;
    private final RequestParamsExtractor<RequestT> paramsExtractor;
    private final RequestMutator<RequestT> requestMutator;
    private final TypeRegistry typeRegistry;

    private HttpJsonCallSettings(Builder<RequestT, ResponseT> builder) {
        this.methodDescriptor = ((Builder)builder).methodDescriptor;
        this.paramsExtractor = ((Builder)builder).paramsExtractor;
        this.requestMutator = ((Builder)builder).requestMutator;
        this.typeRegistry = ((Builder)builder).typeRegistry;
    }

    public ApiMethodDescriptor<RequestT, ResponseT> getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public RequestParamsExtractor<RequestT> getParamsExtractor() {
        return this.paramsExtractor;
    }

    public RequestMutator<RequestT> getRequestMutator() {
        return this.requestMutator;
    }

    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public static <RequestT, ResponseT> Builder<RequestT, ResponseT> newBuilder() {
        return new Builder();
    }

    public static <RequestT, ResponseT> HttpJsonCallSettings<RequestT, ResponseT> create(ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor) {
        return HttpJsonCallSettings.newBuilder().setMethodDescriptor(methodDescriptor).build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder<RequestT, ResponseT> {
        private RequestMutator<RequestT> requestMutator;
        private ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor;
        private RequestParamsExtractor<RequestT> paramsExtractor;
        private TypeRegistry typeRegistry;

        private Builder() {
        }

        private Builder(HttpJsonCallSettings<RequestT, ResponseT> settings) {
            this.methodDescriptor = ((HttpJsonCallSettings)settings).methodDescriptor;
        }

        public Builder<RequestT, ResponseT> setMethodDescriptor(ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor) {
            this.methodDescriptor = methodDescriptor;
            return this;
        }

        public Builder<RequestT, ResponseT> setParamsExtractor(RequestParamsExtractor<RequestT> paramsExtractor) {
            this.paramsExtractor = paramsExtractor;
            return this;
        }

        public Builder<RequestT, ResponseT> setRequestMutator(RequestMutator<RequestT> requestMutator) {
            this.requestMutator = requestMutator;
            return this;
        }

        public Builder<RequestT, ResponseT> setTypeRegistry(TypeRegistry typeRegistry) {
            this.typeRegistry = typeRegistry;
            return this;
        }

        public HttpJsonCallSettings<RequestT, ResponseT> build() {
            return new HttpJsonCallSettings(this);
        }
    }
}

