/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalApi;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TraceFinisher;
import javax.annotation.Nonnull;
import org.apache.iceberg.gcp.shaded.com.google.common.util.concurrent.MoreExecutors;

@InternalApi(value="For internal use by google-cloud-java clients only")
public class TracedOperationCallable<RequestT, ResponseT, MetadataT>
extends OperationCallable<RequestT, ResponseT, MetadataT> {
    @Nonnull
    private OperationCallable<RequestT, ResponseT, MetadataT> innerCallable;
    @Nonnull
    private ApiTracerFactory tracerFactory;
    @Nonnull
    private SpanName spanName;

    public TracedOperationCallable(@Nonnull OperationCallable<RequestT, ResponseT, MetadataT> innerCallable, @Nonnull ApiTracerFactory tracerFactory, @Nonnull SpanName spanName) {
        this.innerCallable = innerCallable;
        this.tracerFactory = tracerFactory;
        this.spanName = spanName;
    }

    @Override
    public OperationFuture<ResponseT, MetadataT> futureCall(RequestT request, ApiCallContext context) {
        ApiTracer tracer = this.tracerFactory.newTracer(context.getTracer(), this.spanName, ApiTracerFactory.OperationType.LongRunning);
        TraceFinisher finisher = new TraceFinisher(tracer);
        try {
            context = context.withTracer(tracer);
            OperationFuture<ResponseT, MetadataT> future = this.innerCallable.futureCall(request, context);
            ApiFutures.addCallback(future, finisher, MoreExecutors.directExecutor());
            return future;
        }
        catch (RuntimeException e) {
            finisher.onFailure(e);
            throw e;
        }
    }

    @Override
    public OperationFuture<ResponseT, MetadataT> resumeFutureCall(String operationName, ApiCallContext context) {
        ApiTracer tracer = this.tracerFactory.newTracer(context.getTracer(), this.spanName, ApiTracerFactory.OperationType.LongRunning);
        TraceFinisher finisher = new TraceFinisher(tracer);
        try {
            context = context.withTracer(tracer);
            OperationFuture<ResponseT, MetadataT> future = this.innerCallable.resumeFutureCall(operationName, context);
            ApiFutures.addCallback(future, finisher, MoreExecutors.directExecutor());
            return future;
        }
        catch (RuntimeException e) {
            finisher.onFailure(e);
            throw e;
        }
    }

    @Override
    public ApiFuture<Void> cancel(String operationName, ApiCallContext context) {
        SpanName cancelSpanName = SpanName.of(this.spanName.getClientName(), this.spanName.getMethodName() + ".Cancel");
        ApiTracer tracer = this.tracerFactory.newTracer(context.getTracer(), cancelSpanName, ApiTracerFactory.OperationType.Unary);
        TraceFinisher finisher = new TraceFinisher(tracer);
        try {
            context = context.withTracer(tracer);
            ApiFuture<Void> future = this.innerCallable.cancel(operationName, context);
            ApiFutures.addCallback(future, finisher, MoreExecutors.directExecutor());
            return future;
        }
        catch (RuntimeException e) {
            finisher.onFailure(e);
            throw e;
        }
    }
}

