/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.http;

import com.google.api.client.extensions.appengine.http.UrlFetchTransport;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.httpjson.HttpHeadersUtils;
import com.google.api.gax.httpjson.HttpJsonStatusCode;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.UnauthenticatedException;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.http.HttpTransportFactory;
import com.google.cloud.NoCredentials;
import com.google.cloud.PlatformInformation;
import com.google.cloud.ServiceOptions;
import com.google.cloud.TransportOptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Objects;
import org.apache.iceberg.gcp.shaded.com.google.common.base.MoreObjects;

public class HttpTransportOptions
implements TransportOptions {
    private static final long serialVersionUID = 7890117765045419810L;
    private final int connectTimeout;
    private final int readTimeout;
    private final String httpTransportFactoryClassName;
    private transient HttpTransportFactory httpTransportFactory;

    public HttpTransportOptions(Builder builder) {
        this.httpTransportFactory = MoreObjects.firstNonNull(builder.httpTransportFactory, ServiceOptions.getFromServiceLoader(HttpTransportFactory.class, DefaultHttpTransportFactory.INSTANCE));
        this.httpTransportFactoryClassName = this.httpTransportFactory.getClass().getName();
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
    }

    public HttpTransportFactory getHttpTransportFactory() {
        return this.httpTransportFactory;
    }

    public HttpRequestInitializer getHttpRequestInitializer(final ServiceOptions<?, ?> serviceOptions) {
        Credentials scopedCredentials = serviceOptions.getScopedCredentials();
        final HttpCredentialsAdapter delegate = scopedCredentials != null && scopedCredentials != NoCredentials.getInstance() ? new HttpCredentialsAdapter(scopedCredentials) : null;
        ApiClientHeaderProvider internalHeaderProvider = this.getInternalHeaderProviderBuilder(serviceOptions).build();
        final HeaderProvider headerProvider = serviceOptions.getMergedHeaderProvider(internalHeaderProvider);
        return new HttpRequestInitializer(){

            private String determineUniverseDomain() {
                String universeDomain = serviceOptions.getUniverseDomain();
                if (universeDomain == null) {
                    universeDomain = System.getenv("GOOGLE_CLOUD_UNIVERSE_DOMAIN");
                }
                return universeDomain == null ? "googleapis.com" : universeDomain;
            }

            @Override
            public void initialize(HttpRequest httpRequest) throws IOException {
                String configuredUniverseDomain = this.determineUniverseDomain();
                String credentialsUniverseDomain = "googleapis.com";
                if (delegate != null) {
                    HttpCredentialsAdapter httpCredentialsAdapter = (HttpCredentialsAdapter)delegate;
                    credentialsUniverseDomain = httpCredentialsAdapter.getCredentials().getUniverseDomain();
                }
                if (!configuredUniverseDomain.equals(credentialsUniverseDomain)) {
                    throw new UnauthenticatedException(new Throwable(String.format("The configured universe domain (%s) does not match the universe domain found in the credentials (%s). If you haven't configured the universe domain explicitly, `googleapis.com` is the default.", configuredUniverseDomain, credentialsUniverseDomain)), HttpJsonStatusCode.of(StatusCode.Code.UNAUTHENTICATED), false);
                }
                if (delegate != null) {
                    delegate.initialize(httpRequest);
                }
                if (HttpTransportOptions.this.connectTimeout >= 0) {
                    httpRequest.setConnectTimeout(HttpTransportOptions.this.connectTimeout);
                }
                if (HttpTransportOptions.this.readTimeout >= 0) {
                    httpRequest.setReadTimeout(HttpTransportOptions.this.readTimeout);
                }
                HttpHeadersUtils.setHeaders(httpRequest.getHeaders(), headerProvider.getHeaders());
            }
        };
    }

    ApiClientHeaderProvider.Builder getInternalHeaderProviderBuilder(ServiceOptions<?, ?> serviceOptions) {
        ApiClientHeaderProvider.Builder builder = ApiClientHeaderProvider.newBuilder();
        builder.setClientLibToken(ServiceOptions.getGoogApiClientLibName(), GaxProperties.getLibraryVersion(serviceOptions.getClass()));
        builder.setQuotaProjectIdToken(serviceOptions.getQuotaProjectId());
        return builder;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public int hashCode() {
        return Objects.hash(this.httpTransportFactoryClassName, this.connectTimeout, this.readTimeout);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpTransportOptions other = (HttpTransportOptions)obj;
        return Objects.equals(this.httpTransportFactoryClassName, other.httpTransportFactoryClassName) && Objects.equals(this.connectTimeout, other.connectTimeout) && Objects.equals(this.readTimeout, other.readTimeout);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.httpTransportFactory = (HttpTransportFactory)ServiceOptions.newInstance(this.httpTransportFactoryClassName);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private HttpTransportFactory httpTransportFactory;
        private int connectTimeout = -1;
        private int readTimeout = -1;

        private Builder() {
        }

        private Builder(HttpTransportOptions options) {
            this.httpTransportFactory = options.httpTransportFactory;
            this.connectTimeout = options.connectTimeout;
            this.readTimeout = options.readTimeout;
        }

        public HttpTransportOptions build() {
            return new HttpTransportOptions(this);
        }

        public Builder setHttpTransportFactory(HttpTransportFactory httpTransportFactory) {
            this.httpTransportFactory = httpTransportFactory;
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }
    }

    public static class DefaultHttpTransportFactory
    implements HttpTransportFactory {
        private static final HttpTransportFactory INSTANCE = new DefaultHttpTransportFactory();

        @Override
        public HttpTransport create() {
            if (PlatformInformation.isOnGAEStandard7()) {
                try {
                    return new UrlFetchTransport();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new NetHttpTransport();
        }
    }
}

