/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BufferHandle;
import com.google.cloud.storage.BufferedWritableByteChannelSession;
import com.google.cloud.storage.Buffers;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.LazyWriteChannel;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageWriteChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.gcp.shaded.com.google.common.util.concurrent.MoreExecutors;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class BaseStorageWriteChannel<T>
implements StorageWriteChannel {
    private final Conversions.Decoder<T, BlobInfo> objectDecoder;
    private final SettableApiFuture<T> result;
    protected final ReentrantLock lock;
    private long position;
    private boolean open;
    private int chunkSize;
    private LazyWriteChannel<T> lazyWriteChannel;
    private BufferHandle bufferHandle;
    protected boolean writeCalledAtLeastOnce;

    protected BaseStorageWriteChannel(Conversions.Decoder<T, BlobInfo> objectDecoder) {
        this.objectDecoder = objectDecoder;
        this.result = SettableApiFuture.create();
        this.lock = new ReentrantLock();
        this.open = true;
        this.chunkSize = 0x1000000;
        this.writeCalledAtLeastOnce = false;
    }

    @Override
    public final void setChunkSize(int chunkSize) {
        this.lock.lock();
        try {
            Preconditions.checkArgument(chunkSize > 0, "chunkSize must be > 0, received %d", chunkSize);
            Preconditions.checkState(this.bufferHandle == null || this.bufferHandle.position() == 0, "unable to change chunk size with data buffered");
            this.chunkSize = chunkSize;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final boolean isOpen() {
        this.lock.lock();
        try {
            boolean bl = this.open;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final void close() throws IOException {
        this.lock.lock();
        try {
            if (this.open && !this.writeCalledAtLeastOnce) {
                this.write(ByteBuffer.allocate(0));
            }
            if (this.internalGetLazyChannel().isOpen()) {
                StorageException.wrapIOException(this.internalGetLazyChannel().getChannel()::close);
            }
        }
        finally {
            this.open = false;
            this.lock.unlock();
        }
    }

    @Override
    public final int write(ByteBuffer src) throws IOException {
        this.lock.lock();
        try {
            int write;
            BufferedWritableByteChannelSession.BufferedWritableByteChannel tmp;
            block10: {
                if (!this.open) {
                    throw new ClosedChannelException();
                }
                this.writeCalledAtLeastOnce = true;
                try {
                    tmp = this.internalGetLazyChannel().getChannel();
                    if (tmp.isOpen()) break block10;
                    int n = 0;
                    return n;
                }
                catch (StorageException e) {
                    throw new IOException(e);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(StorageException.coalesce(e));
                }
            }
            int n = write = tmp.write(src);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public final ApiFuture<BlobInfo> getObject() {
        return ApiFutures.transform(this.result, this.objectDecoder::decode, MoreExecutors.directExecutor());
    }

    protected final BufferHandle getBufferHandle() {
        if (this.bufferHandle == null) {
            this.bufferHandle = BufferHandle.allocate(Buffers.alignSize(this.getChunkSize(), 262144));
        }
        return this.bufferHandle;
    }

    protected final int getChunkSize() {
        return this.chunkSize;
    }

    protected final @Nullable T getResolvedObject() {
        if (this.result.isDone()) {
            return StorageException.wrapFutureGet(this.result);
        }
        return null;
    }

    protected final long getCommittedPosition() {
        return this.position;
    }

    protected final void setCommittedPosition(long l) {
        this.position = l;
    }

    protected final void setOpen(boolean isOpen) {
        this.open = isOpen;
    }

    protected abstract LazyWriteChannel<T> newLazyWriteChannel();

    private LazyWriteChannel<T> internalGetLazyChannel() {
        if (this.lazyWriteChannel == null) {
            LazyWriteChannel<T> tmp = this.newLazyWriteChannel();
            ApiFuture future = tmp.getSession().getResult();
            ApiFutures.addCallback(future, new ApiFutureCallback<T>(){

                @Override
                public void onFailure(Throwable t2) {
                    if (!BaseStorageWriteChannel.this.result.isDone()) {
                        BaseStorageWriteChannel.this.result.setException(t2);
                    }
                }

                @Override
                public void onSuccess(T t2) {
                    if (!BaseStorageWriteChannel.this.result.isDone()) {
                        BaseStorageWriteChannel.this.result.set(t2);
                    }
                }
            }, MoreExecutors.directExecutor());
            this.lazyWriteChannel = tmp;
        }
        return this.lazyWriteChannel;
    }
}

