/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.grpclb;

import io.grpc.Attributes;
import io.grpc.ConnectivityStateInfo;
import io.grpc.EquivalentAddressGroup;
import io.grpc.LoadBalancer;
import io.grpc.SynchronizationContext;
import io.grpc.grpclb.SubchannelPool;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.gcp.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;

final class CachedSubchannelPool
implements SubchannelPool {
    private final HashMap<EquivalentAddressGroup, CacheEntry> cache = new HashMap();
    private final LoadBalancer.Helper helper;
    private SubchannelPool.PooledSubchannelStateListener listener;
    @VisibleForTesting
    static final long SHUTDOWN_TIMEOUT_MS = 10000L;

    public CachedSubchannelPool(LoadBalancer.Helper helper) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
    }

    @Override
    public void registerListener(SubchannelPool.PooledSubchannelStateListener listener) {
        this.listener = Preconditions.checkNotNull(listener, "listener");
    }

    @Override
    public LoadBalancer.Subchannel takeOrCreateSubchannel(EquivalentAddressGroup eag, Attributes defaultAttributes) {
        LoadBalancer.Subchannel subchannel;
        final CacheEntry entry = this.cache.remove(eag);
        if (entry == null) {
            subchannel = this.helper.createSubchannel(LoadBalancer.CreateSubchannelArgs.newBuilder().setAddresses(eag).setAttributes(defaultAttributes).build());
            subchannel.start(new LoadBalancer.SubchannelStateListener(){

                @Override
                public void onSubchannelState(ConnectivityStateInfo newState) {
                    CachedSubchannelPool.this.updateCachedSubchannelState(subchannel, newState);
                    CachedSubchannelPool.this.listener.onSubchannelState(subchannel, newState);
                }
            });
        } else {
            subchannel = entry.subchannel;
            entry.shutdownTimer.cancel();
            this.helper.getSynchronizationContext().execute(new Runnable(){

                @Override
                public void run() {
                    CachedSubchannelPool.this.listener.onSubchannelState(subchannel, entry.state);
                }
            });
        }
        return subchannel;
    }

    private void updateCachedSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo newStateInfo) {
        CacheEntry cached = this.cache.get(subchannel.getAddresses());
        if (cached == null || cached.subchannel != subchannel) {
            return;
        }
        cached.state = newStateInfo;
    }

    @Override
    public void returnSubchannel(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo lastKnownState) {
        CacheEntry prev = this.cache.get(subchannel.getAddresses());
        if (prev != null) {
            if (prev.subchannel != subchannel) {
                subchannel.shutdown();
            }
            return;
        }
        ShutdownSubchannelTask shutdownTask = new ShutdownSubchannelTask(subchannel);
        SynchronizationContext.ScheduledHandle shutdownTimer = this.helper.getSynchronizationContext().schedule(shutdownTask, 10000L, TimeUnit.MILLISECONDS, this.helper.getScheduledExecutorService());
        CacheEntry entry = new CacheEntry(subchannel, shutdownTimer, lastKnownState);
        this.cache.put(subchannel.getAddresses(), entry);
    }

    @Override
    public void clear() {
        for (CacheEntry entry : this.cache.values()) {
            entry.shutdownTimer.cancel();
            entry.subchannel.shutdown();
        }
        this.cache.clear();
    }

    private static class CacheEntry {
        final LoadBalancer.Subchannel subchannel;
        final SynchronizationContext.ScheduledHandle shutdownTimer;
        ConnectivityStateInfo state;

        CacheEntry(LoadBalancer.Subchannel subchannel, SynchronizationContext.ScheduledHandle shutdownTimer, ConnectivityStateInfo state) {
            this.subchannel = Preconditions.checkNotNull(subchannel, "subchannel");
            this.shutdownTimer = Preconditions.checkNotNull(shutdownTimer, "shutdownTimer");
            this.state = Preconditions.checkNotNull(state, "state");
        }
    }

    @VisibleForTesting
    final class ShutdownSubchannelTask
    implements Runnable {
        private final LoadBalancer.Subchannel subchannel;

        private ShutdownSubchannelTask(LoadBalancer.Subchannel subchannel) {
            this.subchannel = Preconditions.checkNotNull(subchannel, "subchannel");
        }

        @Override
        public void run() {
            CacheEntry entry = (CacheEntry)CachedSubchannelPool.this.cache.remove(this.subchannel.getAddresses());
            Preconditions.checkState(entry.subchannel == this.subchannel, "Inconsistent state");
            this.subchannel.shutdown();
        }
    }
}

