/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.opentelemetry;

import io.grpc.Metadata;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.api.trace.TraceState;
import java.util.Arrays;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;

final class BinaryFormat
implements Metadata.BinaryMarshaller<SpanContext> {
    private static final byte VERSION_ID = 0;
    private static final int VERSION_ID_OFFSET = 0;
    private static final byte ID_SIZE = 1;
    private static final byte TRACE_ID_FIELD_ID = 0;
    private static final int TRACE_ID_FIELD_ID_OFFSET = 1;
    private static final int TRACE_ID_OFFSET = 2;
    private static final int TRACE_ID_SIZE = TraceId.getLength() / 2;
    private static final byte SPAN_ID_FIELD_ID = 1;
    private static final int SPAN_ID_FIELD_ID_OFFSET = 2 + TRACE_ID_SIZE;
    private static final int SPAN_ID_OFFSET = SPAN_ID_FIELD_ID_OFFSET + 1;
    private static final int SPAN_ID_SIZE = SpanId.getLength() / 2;
    private static final byte TRACE_FLAG_FIELD_ID = 2;
    private static final int TRACE_FLAG_FIELD_ID_OFFSET = SPAN_ID_OFFSET + SPAN_ID_SIZE;
    private static final int TRACE_FLAG_OFFSET = TRACE_FLAG_FIELD_ID_OFFSET + 1;
    private static final int REQUIRED_FORMAT_LENGTH = 3 + TRACE_ID_SIZE + SPAN_ID_SIZE;
    private static final int TRACE_FLAG_SIZE = TraceFlags.getLength() / 2;
    private static final int ALL_FORMAT_LENGTH = REQUIRED_FORMAT_LENGTH + 1 + TRACE_FLAG_SIZE;
    private static final BinaryFormat INSTANCE = new BinaryFormat();

    BinaryFormat() {
    }

    public static BinaryFormat getInstance() {
        return INSTANCE;
    }

    @Override
    public byte[] toBytes(SpanContext spanContext) {
        Preconditions.checkNotNull(spanContext, "spanContext");
        byte[] bytes = new byte[ALL_FORMAT_LENGTH];
        bytes[0] = 0;
        bytes[1] = 0;
        System.arraycopy(spanContext.getTraceIdBytes(), 0, bytes, 2, TRACE_ID_SIZE);
        bytes[BinaryFormat.SPAN_ID_FIELD_ID_OFFSET] = 1;
        System.arraycopy(spanContext.getSpanIdBytes(), 0, bytes, SPAN_ID_OFFSET, SPAN_ID_SIZE);
        bytes[BinaryFormat.TRACE_FLAG_FIELD_ID_OFFSET] = 2;
        bytes[BinaryFormat.TRACE_FLAG_OFFSET] = spanContext.getTraceFlags().asByte();
        return bytes;
    }

    @Override
    public SpanContext parseBytes(byte[] serialized) {
        Preconditions.checkNotNull(serialized, "bytes");
        if (serialized.length == 0 || serialized[0] != 0) {
            throw new IllegalArgumentException("Unsupported version.");
        }
        if (serialized.length < REQUIRED_FORMAT_LENGTH) {
            throw new IllegalArgumentException("Invalid input: truncated");
        }
        TraceFlags traceFlags = TraceFlags.getDefault();
        int pos = 1;
        if (serialized[pos] != 0) {
            throw new IllegalArgumentException("Invalid input: expected trace ID at offset " + pos);
        }
        String traceId = TraceId.fromBytes(Arrays.copyOfRange(serialized, pos + 1, pos + 1 + TRACE_ID_SIZE));
        if (serialized[pos += 1 + TRACE_ID_SIZE] != 1) {
            throw new IllegalArgumentException("Invalid input: expected span ID at offset " + pos);
        }
        String spanId = SpanId.fromBytes(Arrays.copyOfRange(serialized, pos + 1, pos + 1 + SPAN_ID_SIZE));
        if (serialized.length > (pos += 1 + SPAN_ID_SIZE) && serialized[pos] == 2) {
            if (serialized.length < ALL_FORMAT_LENGTH) {
                throw new IllegalArgumentException("Invalid input: truncated");
            }
            traceFlags = TraceFlags.fromByte(serialized[pos + 1]);
        }
        return SpanContext.create(traceId, spanId, traceFlags, TraceState.getDefault());
    }
}

