/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.client;

import io.grpc.Internal;
import io.grpc.InternalLogId;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.TimeProvider;
import io.grpc.xds.client.Bootstrapper;
import io.grpc.xds.client.ControlPlaneClient;
import io.grpc.xds.client.LoadReportClient;
import io.grpc.xds.client.LoadStatsManager2;
import io.grpc.xds.client.Locality;
import io.grpc.xds.client.MessagePrettyPrinter;
import io.grpc.xds.client.XdsClient;
import io.grpc.xds.client.XdsClientMetricReporter;
import io.grpc.xds.client.XdsLogger;
import io.grpc.xds.client.XdsResourceType;
import io.grpc.xds.client.XdsTransportFactory;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.iceberg.gcp.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Joiner;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Preconditions;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Stopwatch;
import org.apache.iceberg.gcp.shaded.com.google.common.base.Supplier;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableList;
import org.apache.iceberg.gcp.shaded.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.gcp.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.iceberg.gcp.shaded.com.google.common.util.concurrent.SettableFuture;
import org.apache.iceberg.gcp.shaded.com.google.protobuf.Any;

@Internal
public final class XdsClientImpl
extends XdsClient
implements XdsClient.ResourceStore {
    @VisibleForTesting
    public static final int INITIAL_RESOURCE_FETCH_TIMEOUT_SEC = 15;
    private final SynchronizationContext syncContext = new SynchronizationContext(new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t2, Throwable e) {
            XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.ERROR, "Uncaught exception in XdsClient SynchronizationContext. Panic!", e);
            throw new AssertionError((Object)e);
        }
    });
    private final Map<Bootstrapper.ServerInfo, LoadStatsManager2> loadStatsManagerMap = new HashMap<Bootstrapper.ServerInfo, LoadStatsManager2>();
    final Map<Bootstrapper.ServerInfo, LoadReportClient> serverLrsClientMap = new HashMap<Bootstrapper.ServerInfo, LoadReportClient>();
    private final Map<String, List<ControlPlaneClient>> activatedCpClients = new HashMap<String, List<ControlPlaneClient>>();
    private final Map<Bootstrapper.ServerInfo, ControlPlaneClient> serverCpClientMap = new HashMap<Bootstrapper.ServerInfo, ControlPlaneClient>();
    private final Map<XdsResourceType<? extends XdsClient.ResourceUpdate>, Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>>> resourceSubscribers = new HashMap<XdsResourceType<? extends XdsClient.ResourceUpdate>, Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>>>();
    private final Map<String, XdsResourceType<?>> subscribedResourceTypeUrls = new HashMap();
    private final XdsTransportFactory xdsTransportFactory;
    private final Bootstrapper.BootstrapInfo bootstrapInfo;
    private final ScheduledExecutorService timeService;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private final TimeProvider timeProvider;
    private final Object securityConfig;
    private final InternalLogId logId;
    private final XdsLogger logger;
    private volatile boolean isShutdown;
    private final MessagePrettyPrinter messagePrinter;
    private final XdsClientMetricReporter metricReporter;

    public XdsClientImpl(XdsTransportFactory xdsTransportFactory, Bootstrapper.BootstrapInfo bootstrapInfo, ScheduledExecutorService timeService, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier, TimeProvider timeProvider, MessagePrettyPrinter messagePrinter, Object securityConfig, XdsClientMetricReporter metricReporter) {
        this.xdsTransportFactory = xdsTransportFactory;
        this.bootstrapInfo = bootstrapInfo;
        this.timeService = timeService;
        this.backoffPolicyProvider = backoffPolicyProvider;
        this.stopwatchSupplier = stopwatchSupplier;
        this.timeProvider = timeProvider;
        this.messagePrinter = messagePrinter;
        this.securityConfig = securityConfig;
        this.metricReporter = metricReporter;
        this.logId = InternalLogId.allocate("xds-client", null);
        this.logger = XdsLogger.withLogId(this.logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    @Override
    public void shutdown() {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (XdsClientImpl.this.isShutdown) {
                    return;
                }
                XdsClientImpl.this.isShutdown = true;
                for (ControlPlaneClient xdsChannel : XdsClientImpl.this.serverCpClientMap.values()) {
                    xdsChannel.shutdown();
                }
                for (LoadReportClient lrsClient : XdsClientImpl.this.serverLrsClientMap.values()) {
                    lrsClient.stopLoadReporting();
                }
                XdsClientImpl.this.cleanUpResourceTimers(null);
                XdsClientImpl.this.activatedCpClients.clear();
            }
        });
    }

    @Override
    public boolean isShutDown() {
        return this.isShutdown;
    }

    @Override
    public Map<String, XdsResourceType<?>> getSubscribedResourceTypesWithTypeUrl() {
        return Collections.unmodifiableMap(this.subscribedResourceTypeUrls);
    }

    private ControlPlaneClient getActiveCpc(String authority) {
        List<ControlPlaneClient> controlPlaneClients = this.activatedCpClients.get(authority);
        if (controlPlaneClients == null || controlPlaneClients.isEmpty()) {
            return null;
        }
        return controlPlaneClients.get(controlPlaneClients.size() - 1);
    }

    @Override
    @Nullable
    public Collection<String> getSubscribedResources(Bootstrapper.ServerInfo serverInfo, XdsResourceType<? extends XdsClient.ResourceUpdate> type) {
        ControlPlaneClient targetCpc = this.serverCpClientMap.get(serverInfo);
        if (targetCpc == null) {
            return null;
        }
        List authorities = this.activatedCpClients.entrySet().stream().filter(entry -> ((List)entry.getValue()).contains(targetCpc)).map(Map.Entry::getKey).collect(Collectors.toList());
        Map resources = this.resourceSubscribers.getOrDefault(type, Collections.emptyMap());
        Collection retVal = resources.entrySet().stream().filter(entry -> authorities.contains(((ResourceSubscriber)entry.getValue()).authority)).map(Map.Entry::getKey).collect(Collectors.toList());
        return retVal.isEmpty() ? null : retVal;
    }

    @Override
    public void startMissingResourceTimers(Collection<String> resourceNames, XdsResourceType<?> resourceType) {
        Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>> subscriberMap = this.resourceSubscribers.get(resourceType);
        for (String resourceName : resourceNames) {
            ResourceSubscriber<? extends XdsClient.ResourceUpdate> subscriber = subscriberMap.get(resourceName);
            if (((ResourceSubscriber)subscriber).respTimer != null || subscriber.hasResult()) continue;
            subscriber.restartTimer();
        }
    }

    @Override
    public ListenableFuture<Map<XdsResourceType<?>, Map<String, XdsClient.ResourceMetadata>>> getSubscribedResourcesMetadataSnapshot() {
        final SettableFuture<Map<XdsResourceType<?>, Map<String, XdsClient.ResourceMetadata>>> future = SettableFuture.create();
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ImmutableMap.Builder metadataSnapshot = ImmutableMap.builder();
                for (XdsResourceType resourceType : XdsClientImpl.this.resourceSubscribers.keySet()) {
                    ImmutableMap.Builder<String, XdsClient.ResourceMetadata> metadataMap = ImmutableMap.builder();
                    for (Map.Entry resourceEntry : ((Map)XdsClientImpl.this.resourceSubscribers.get(resourceType)).entrySet()) {
                        metadataMap.put((String)resourceEntry.getKey(), ((ResourceSubscriber)resourceEntry.getValue()).metadata);
                    }
                    metadataSnapshot.put(resourceType, metadataMap.buildOrThrow());
                }
                future.set(metadataSnapshot.buildOrThrow());
            }
        });
        return future;
    }

    @Override
    public Object getSecurityConfig() {
        return this.securityConfig;
    }

    @Override
    public <T extends XdsClient.ResourceUpdate> void watchXdsResource(final XdsResourceType<T> type, final String resourceName, final XdsClient.ResourceWatcher<T> watcher, final Executor watcherExecutor) {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber;
                if (!XdsClientImpl.this.resourceSubscribers.containsKey(type)) {
                    XdsClientImpl.this.resourceSubscribers.put(type, new HashMap());
                    XdsClientImpl.this.subscribedResourceTypeUrls.put(type.typeUrl(), type);
                }
                if ((subscriber = (ResourceSubscriber)((Map)XdsClientImpl.this.resourceSubscribers.get(type)).get(resourceName)) == null) {
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Subscribe {0} resource {1}", type, resourceName);
                    subscriber = new ResourceSubscriber(type, resourceName);
                    ((Map)XdsClientImpl.this.resourceSubscribers.get(type)).put(resourceName, subscriber);
                    if (subscriber.errorDescription == null) {
                        CpcWithFallbackState cpcToUse = XdsClientImpl.this.manageControlPlaneClient(subscriber);
                        if (cpcToUse.cpc != null) {
                            cpcToUse.cpc.adjustResourceSubscription(type);
                        }
                    }
                }
                subscriber.addWatcher(watcher, watcherExecutor);
            }
        });
    }

    @VisibleForTesting
    private <T extends XdsClient.ResourceUpdate> CpcWithFallbackState manageControlPlaneClient(ResourceSubscriber<T> subscriber) {
        ControlPlaneClient cpcToUse;
        boolean didFallback = false;
        try {
            cpcToUse = this.getOrCreateControlPlaneClient(((ResourceSubscriber)subscriber).authority);
        }
        catch (IllegalArgumentException e) {
            if (((ResourceSubscriber)subscriber).errorDescription == null) {
                ((ResourceSubscriber)subscriber).errorDescription = "Bad configuration:  " + e.getMessage();
            }
            subscriber.onError(Status.INVALID_ARGUMENT.withDescription(((ResourceSubscriber)subscriber).errorDescription), null);
            return new CpcWithFallbackState(null, false);
        }
        catch (IOException e) {
            this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Could not create a control plane client for authority {0}: {1}", ((ResourceSubscriber)subscriber).authority, e.getMessage());
            return new CpcWithFallbackState(null, false);
        }
        ControlPlaneClient activeCpClient = this.getActiveCpc(((ResourceSubscriber)subscriber).authority);
        if (cpcToUse != activeCpClient) {
            this.addCpcToAuthority(((ResourceSubscriber)subscriber).authority, cpcToUse);
            if (activeCpClient != null) {
                boolean bl = didFallback = cpcToUse != null && !cpcToUse.isInError();
                if (didFallback) {
                    this.logger.log(XdsLogger.XdsLogLevel.INFO, "Falling back to XDS server {0}", cpcToUse.getServerInfo().target());
                } else {
                    this.logger.log(XdsLogger.XdsLogLevel.WARNING, "No working fallback XDS Servers found from {0}", activeCpClient.getServerInfo().target());
                }
            }
        }
        return new CpcWithFallbackState(cpcToUse, didFallback);
    }

    private void addCpcToAuthority(String authority, ControlPlaneClient cpcToUse) {
        List controlPlaneClients = this.activatedCpClients.computeIfAbsent(authority, k -> new ArrayList());
        if (controlPlaneClients.contains(cpcToUse)) {
            return;
        }
        ImmutableList<Bootstrapper.ServerInfo> serverInfos = this.getServerInfos(authority);
        for (int i = controlPlaneClients.size(); i < serverInfos.size(); ++i) {
            Bootstrapper.ServerInfo serverInfo = (Bootstrapper.ServerInfo)serverInfos.get(i);
            ControlPlaneClient cpc = this.serverCpClientMap.get(serverInfo);
            controlPlaneClients.add(cpc);
            this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Adding control plane client {0} to authority {1}", cpc, authority);
            cpcToUse.sendDiscoveryRequests();
            if (cpc == cpcToUse) break;
        }
    }

    @Override
    public <T extends XdsClient.ResourceUpdate> void cancelXdsResourceWatch(final XdsResourceType<T> type, final String resourceName, final XdsClient.ResourceWatcher<T> watcher) {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)((Map)XdsClientImpl.this.resourceSubscribers.get(type)).get(resourceName);
                if (subscriber == null) {
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "double cancel of resource watch for {0}:{1}", type.typeName(), resourceName);
                    return;
                }
                subscriber.removeWatcher(watcher);
                if (!subscriber.isWatched()) {
                    subscriber.cancelResourceWatch();
                    ((Map)XdsClientImpl.this.resourceSubscribers.get(type)).remove(resourceName);
                    List controlPlaneClients = (List)XdsClientImpl.this.activatedCpClients.get(subscriber.authority);
                    if (controlPlaneClients != null) {
                        controlPlaneClients.forEach(cpc -> cpc.adjustResourceSubscription(type));
                    }
                    if (((Map)XdsClientImpl.this.resourceSubscribers.get(type)).isEmpty()) {
                        XdsClientImpl.this.resourceSubscribers.remove(type);
                        XdsClientImpl.this.subscribedResourceTypeUrls.remove(type.typeUrl());
                    }
                }
            }
        });
    }

    @Override
    public LoadStatsManager2.ClusterDropStats addClusterDropStats(final Bootstrapper.ServerInfo serverInfo, String clusterName, @Nullable String edsServiceName) {
        LoadStatsManager2 loadStatsManager = this.loadStatsManagerMap.get(serverInfo);
        LoadStatsManager2.ClusterDropStats dropCounter = loadStatsManager.getClusterDropStats(clusterName, edsServiceName);
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                XdsClientImpl.this.serverLrsClientMap.get(serverInfo).startLoadReporting();
            }
        });
        return dropCounter;
    }

    @Override
    public LoadStatsManager2.ClusterLocalityStats addClusterLocalityStats(final Bootstrapper.ServerInfo serverInfo, String clusterName, @Nullable String edsServiceName, Locality locality) {
        LoadStatsManager2 loadStatsManager = this.loadStatsManagerMap.get(serverInfo);
        LoadStatsManager2.ClusterLocalityStats loadCounter = loadStatsManager.getClusterLocalityStats(clusterName, edsServiceName, locality);
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                XdsClientImpl.this.serverLrsClientMap.get(serverInfo).startLoadReporting();
            }
        });
        return loadCounter;
    }

    @Override
    public Bootstrapper.BootstrapInfo getBootstrapInfo() {
        return this.bootstrapInfo;
    }

    public String toString() {
        return this.logId.toString();
    }

    private Set<String> getResourceKeys(XdsResourceType<?> xdsResourceType) {
        if (!this.resourceSubscribers.containsKey(xdsResourceType)) {
            return null;
        }
        return this.resourceSubscribers.get(xdsResourceType).keySet();
    }

    private void cleanUpResourceTimers(ControlPlaneClient cpcForThisStream) {
        Collection<String> authoritiesForCpc = this.getActiveAuthorities(cpcForThisStream);
        String target = cpcForThisStream == null ? "null" : cpcForThisStream.getServerInfo().target();
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Cleaning up resource timers for CPC {0}, authorities {1}", target, authoritiesForCpc);
        for (Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>> subscriberMap : this.resourceSubscribers.values()) {
            for (ResourceSubscriber<? extends XdsClient.ResourceUpdate> subscriber : subscriberMap.values()) {
                if (cpcForThisStream != null && !authoritiesForCpc.contains(((ResourceSubscriber)subscriber).authority)) continue;
                subscriber.stopTimer();
            }
        }
    }

    private ControlPlaneClient getOrCreateControlPlaneClient(String authority) throws IOException {
        ControlPlaneClient activeCpc = this.getActiveCpc(authority);
        if (activeCpc != null && !activeCpc.isInError()) {
            return activeCpc;
        }
        ImmutableList<Bootstrapper.ServerInfo> serverInfos = this.getServerInfos(authority);
        if (serverInfos == null) {
            throw new IllegalArgumentException("No xds servers found for authority " + authority);
        }
        for (Bootstrapper.ServerInfo serverInfo : serverInfos) {
            ControlPlaneClient cpc = this.getOrCreateControlPlaneClient(serverInfo);
            if (cpc.isInError()) continue;
            return cpc;
        }
        throw new IOException("All xds transports for authority " + authority + " are in backoff");
    }

    private ControlPlaneClient getOrCreateControlPlaneClient(Bootstrapper.ServerInfo serverInfo) {
        XdsTransportFactory.XdsTransport xdsTransport;
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.serverCpClientMap.containsKey(serverInfo)) {
            return this.serverCpClientMap.get(serverInfo);
        }
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Creating control plane client for {0}", serverInfo.target());
        try {
            xdsTransport = this.xdsTransportFactory.create(serverInfo);
        }
        catch (Exception e) {
            String msg = String.format("Failed to create xds transport for %s: %s", serverInfo.target(), e.getMessage());
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, msg);
            xdsTransport = new ControlPlaneClient.FailingXdsTransport(Status.UNAVAILABLE.withDescription(msg));
        }
        ControlPlaneClient controlPlaneClient = new ControlPlaneClient(xdsTransport, serverInfo, this.bootstrapInfo.node(), new ResponseHandler(serverInfo), this, this.timeService, this.syncContext, this.backoffPolicyProvider, this.stopwatchSupplier, this.messagePrinter);
        this.serverCpClientMap.put(serverInfo, controlPlaneClient);
        LoadStatsManager2 loadStatsManager = new LoadStatsManager2(this.stopwatchSupplier);
        this.loadStatsManagerMap.put(serverInfo, loadStatsManager);
        LoadReportClient lrsClient = new LoadReportClient(loadStatsManager, xdsTransport, this.bootstrapInfo.node(), this.syncContext, this.timeService, this.backoffPolicyProvider, this.stopwatchSupplier);
        this.serverLrsClientMap.put(serverInfo, lrsClient);
        return controlPlaneClient;
    }

    @Override
    @VisibleForTesting
    public Map<Bootstrapper.ServerInfo, LoadReportClient> getServerLrsClientMap() {
        return ImmutableMap.copyOf(this.serverLrsClientMap);
    }

    private String getAuthority(String resource) {
        String authority;
        if (resource.startsWith("xdstp:")) {
            URI uri = URI.create(resource);
            authority = uri.getAuthority();
            if (authority == null) {
                authority = "";
            }
        } else {
            authority = null;
        }
        return authority;
    }

    @Nullable
    private ImmutableList<Bootstrapper.ServerInfo> getServerInfos(String authority) {
        if (authority != null) {
            Bootstrapper.AuthorityInfo authorityInfo = this.bootstrapInfo.authorities().get(authority);
            if (authorityInfo == null || authorityInfo.xdsServers().isEmpty()) {
                return null;
            }
            return authorityInfo.xdsServers();
        }
        return this.bootstrapInfo.servers();
    }

    private <T extends XdsClient.ResourceUpdate> void handleResourceUpdate(XdsResourceType.Args args, List<Any> resources, XdsResourceType<T> xdsResourceType, boolean isFirstResponse, XdsClient.ProcessingTracker processingTracker) {
        ControlPlaneClient controlPlaneClient = this.serverCpClientMap.get(args.serverInfo);
        if (isFirstResponse) {
            this.shutdownLowerPriorityCpcs(controlPlaneClient);
        }
        XdsResourceType.ValidatedResourceUpdate<T> result = xdsResourceType.parse(args, resources);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received {0} Response version {1} nonce {2}. Parsed resources: {3}", xdsResourceType.typeName(), args.versionInfo, args.nonce, result.unpackedResources);
        Map parsedResources = result.parsedResources;
        Set<String> invalidResources = result.invalidResources;
        this.metricReporter.reportResourceUpdates(parsedResources.size(), invalidResources.size(), args.getServerInfo().target(), xdsResourceType.typeUrl());
        List<String> errors = result.errors;
        String errorDetail = null;
        if (errors.isEmpty()) {
            Preconditions.checkArgument(invalidResources.isEmpty(), "found invalid resources but missing errors");
            controlPlaneClient.ackResponse(xdsResourceType, args.versionInfo, args.nonce);
        } else {
            errorDetail = Joiner.on('\n').join(errors);
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed processing {0} Response version {1} nonce {2}. Errors:\n{3}", xdsResourceType.typeName(), args.versionInfo, args.nonce, errorDetail);
            controlPlaneClient.nackResponse(xdsResourceType, args.nonce, errorDetail);
        }
        long updateTime = this.timeProvider.currentTimeNanos();
        Map subscribedResources = this.resourceSubscribers.getOrDefault(xdsResourceType, Collections.emptyMap());
        for (Map.Entry entry : subscribedResources.entrySet()) {
            String resourceName = (String)entry.getKey();
            ResourceSubscriber subscriber = (ResourceSubscriber)entry.getValue();
            if (parsedResources.containsKey(resourceName)) {
                subscriber.onData(parsedResources.get(resourceName), args.versionInfo, updateTime, processingTracker);
                continue;
            }
            if (invalidResources.contains(resourceName)) {
                subscriber.onRejected(args.versionInfo, updateTime, errorDetail);
            }
            if (!xdsResourceType.isFullStateOfTheWorld()) continue;
            if (invalidResources.contains(resourceName)) {
                if (subscriber.data != null) continue;
                subscriber.onError(Status.UNAVAILABLE.withDescription(errorDetail), processingTracker);
                continue;
            }
            if (this.getActiveCpc(subscriber.authority) != controlPlaneClient) continue;
            subscriber.onAbsent(processingTracker, args.serverInfo);
        }
    }

    @Override
    public Future<Void> reportServerConnections(XdsClient.ServerConnectionCallback callback) {
        SettableFuture<Void> future = SettableFuture.create();
        this.syncContext.execute(() -> {
            this.serverCpClientMap.forEach((serverInfo, controlPlaneClient) -> callback.reportServerConnectionGauge(!controlPlaneClient.isInError(), serverInfo.target()));
            future.set(null);
        });
        return future;
    }

    private void shutdownLowerPriorityCpcs(ControlPlaneClient activatedCpc) {
        HashSet<ControlPlaneClient> cpcsToShutdown = new HashSet<ControlPlaneClient>();
        for (List<ControlPlaneClient> cpcsForAuth : this.activatedCpClients.values()) {
            int index;
            if (cpcsForAuth == null || (index = cpcsForAuth.indexOf(activatedCpc)) <= -1) continue;
            cpcsToShutdown.addAll(cpcsForAuth.subList(index + 1, cpcsForAuth.size()));
            cpcsForAuth.subList(index + 1, cpcsForAuth.size()).clear();
        }
        for (ControlPlaneClient cpc : cpcsToShutdown) {
            if (this.activatedCpClients.values().stream().noneMatch(list -> list.contains(cpc))) {
                cpc.shutdown();
                this.serverCpClientMap.remove(cpc.getServerInfo());
                continue;
            }
            cpc.sendDiscoveryRequests();
        }
    }

    private Collection<String> getActiveAuthorities(ControlPlaneClient cpc) {
        List asList = this.activatedCpClients.entrySet().stream().filter(entry -> !((List)entry.getValue()).isEmpty() && cpc == ((List)entry.getValue()).get(((List)entry.getValue()).size() - 1)).map(Map.Entry::getKey).collect(Collectors.toList());
        return asList.size() < 100 ? asList : new HashSet(asList);
    }

    private static class CpcWithFallbackState {
        ControlPlaneClient cpc;
        boolean didFallback;

        private CpcWithFallbackState(ControlPlaneClient cpc, boolean didFallback) {
            this.cpc = cpc;
            this.didFallback = didFallback;
        }
    }

    private class ResponseHandler
    implements XdsClient.XdsResponseHandler {
        final Bootstrapper.ServerInfo serverInfo;

        ResponseHandler(Bootstrapper.ServerInfo serverInfo) {
            this.serverInfo = serverInfo;
        }

        @Override
        public void handleResourceResponse(XdsResourceType<?> xdsResourceType, Bootstrapper.ServerInfo serverInfo, String versionInfo, List<Any> resources, String nonce, boolean isFirstResponse, XdsClient.ProcessingTracker processingTracker) {
            Preconditions.checkNotNull(xdsResourceType, "xdsResourceType");
            XdsClientImpl.this.syncContext.throwIfNotInThisSynchronizationContext();
            Set toParseResourceNames = xdsResourceType.shouldRetrieveResourceKeysForArgs() ? XdsClientImpl.this.getResourceKeys(xdsResourceType) : null;
            XdsResourceType.Args args = new XdsResourceType.Args(serverInfo, versionInfo, nonce, XdsClientImpl.this.bootstrapInfo, XdsClientImpl.this.securityConfig, toParseResourceNames);
            XdsClientImpl.this.handleResourceUpdate(args, resources, xdsResourceType, isFirstResponse, processingTracker);
        }

        @Override
        public void handleStreamClosed(Status status, boolean shouldTryFallback) {
            XdsClientImpl.this.syncContext.throwIfNotInThisSynchronizationContext();
            ControlPlaneClient cpcClosed = (ControlPlaneClient)XdsClientImpl.this.serverCpClientMap.get(this.serverInfo);
            if (cpcClosed == null) {
                XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Couldn't find closing CPC for {0}, so skipping cleanup and reporting", this.serverInfo);
                return;
            }
            XdsClientImpl.this.cleanUpResourceTimers(cpcClosed);
            if (status.isOk()) {
                return;
            }
            XdsClientImpl.this.metricReporter.reportServerFailure(1L, this.serverInfo.target());
            Collection authoritiesForClosedCpc = XdsClientImpl.this.getActiveAuthorities(cpcClosed);
            for (Map subscriberMap : XdsClientImpl.this.resourceSubscribers.values()) {
                for (ResourceSubscriber subscriber : subscriberMap.values()) {
                    if (subscriber.hasResult() || !authoritiesForClosedCpc.contains(subscriber.authority)) continue;
                    if (shouldTryFallback && ((XdsClientImpl)XdsClientImpl.this).manageControlPlaneClient((ResourceSubscriber)subscriber).didFallback) {
                        authoritiesForClosedCpc.remove(subscriber.authority);
                        if (!authoritiesForClosedCpc.isEmpty()) continue;
                        return;
                    }
                    subscriber.onError(status, null);
                }
            }
        }
    }

    private final class ResourceSubscriber<T extends XdsClient.ResourceUpdate> {
        @Nullable
        private final String authority;
        private final XdsResourceType<T> type;
        private final String resource;
        private final Map<XdsClient.ResourceWatcher<T>, Executor> watchers = new HashMap<XdsClient.ResourceWatcher<T>, Executor>();
        @Nullable
        private T data;
        private boolean absent;
        private boolean resourceDeletionIgnored;
        @Nullable
        private SynchronizationContext.ScheduledHandle respTimer;
        @Nullable
        private XdsClient.ResourceMetadata metadata;
        @Nullable
        private String errorDescription;

        ResourceSubscriber(XdsResourceType<T> type, String resource) {
            XdsClientImpl.this.syncContext.throwIfNotInThisSynchronizationContext();
            this.type = type;
            this.resource = resource;
            this.authority = XdsClientImpl.this.getAuthority(resource);
            if (XdsClientImpl.this.getServerInfos(this.authority) == null) {
                this.errorDescription = "Wrong configuration: xds server does not exist for resource " + resource;
                return;
            }
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataUnknown();
        }

        public String toString() {
            return "ResourceSubscriber{resource='" + this.resource + '\'' + ", authority='" + this.authority + '\'' + ", type=" + this.type + ", watchers=" + this.watchers.size() + ", data=" + this.data + ", absent=" + this.absent + ", resourceDeletionIgnored=" + this.resourceDeletionIgnored + ", errorDescription='" + this.errorDescription + '\'' + '}';
        }

        void addWatcher(XdsClient.ResourceWatcher<T> watcher, Executor watcherExecutor) {
            Preconditions.checkArgument(!this.watchers.containsKey(watcher), "watcher %s already registered", watcher);
            this.watchers.put(watcher, watcherExecutor);
            T savedData = this.data;
            boolean savedAbsent = this.absent;
            watcherExecutor.execute(() -> {
                if (this.errorDescription != null) {
                    watcher.onError(Status.INVALID_ARGUMENT.withDescription(this.errorDescription));
                    return;
                }
                if (savedData != null) {
                    this.notifyWatcher(watcher, savedData);
                } else if (savedAbsent) {
                    watcher.onResourceDoesNotExist(this.resource);
                }
            });
        }

        void removeWatcher(XdsClient.ResourceWatcher<T> watcher) {
            Preconditions.checkArgument(this.watchers.containsKey(watcher), "watcher %s not registered", watcher);
            this.watchers.remove(watcher);
        }

        void restartTimer() {
            if (this.data != null || this.absent) {
                return;
            }
            final ControlPlaneClient activeCpc = XdsClientImpl.this.getActiveCpc(this.authority);
            if (activeCpc == null || !activeCpc.isReady()) {
                return;
            }
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataRequested();
            if (this.respTimer != null) {
                this.respTimer.cancel();
            }
            class ResourceNotFound
            implements Runnable {
                ResourceNotFound() {
                }

                @Override
                public void run() {
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "{0} resource {1} initial fetch timeout", ResourceSubscriber.this.type, ResourceSubscriber.this.resource);
                    ResourceSubscriber.this.respTimer = null;
                    ResourceSubscriber.this.onAbsent(null, activeCpc.getServerInfo());
                }

                public String toString() {
                    return ResourceSubscriber.this.type + this.getClass().getSimpleName();
                }
            }
            this.respTimer = XdsClientImpl.this.syncContext.schedule(new ResourceNotFound(), 15L, TimeUnit.SECONDS, XdsClientImpl.this.timeService);
        }

        void stopTimer() {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
        }

        void cancelResourceWatch() {
            if (this.isWatched()) {
                throw new IllegalStateException("Can't cancel resource watch with active watchers present");
            }
            this.stopTimer();
            String message = "Unsubscribing {0} resource {1} from server {2}";
            XdsLogger.XdsLogLevel logLevel = XdsLogger.XdsLogLevel.INFO;
            if (this.resourceDeletionIgnored) {
                message = message + " for which we previously ignored a deletion";
                logLevel = XdsLogger.XdsLogLevel.FORCE_INFO;
            }
            XdsClientImpl.this.logger.log(logLevel, message, this.type, this.resource, this.getTarget());
        }

        boolean isWatched() {
            return !this.watchers.isEmpty();
        }

        boolean hasResult() {
            return this.data != null || this.absent;
        }

        void onData(XdsResourceType.ParsedResource<T> parsedResource, String version, long updateTime, XdsClient.ProcessingTracker processingTracker) {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
            T oldData = this.data;
            this.data = parsedResource.getResourceUpdate();
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataAcked(parsedResource.getRawResource(), version, updateTime);
            this.absent = false;
            if (this.resourceDeletionIgnored) {
                XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.FORCE_INFO, "xds server {0}: server returned new version of resource for which we previously ignored a deletion: type {1} name {2}", this.getTarget(), this.type, this.resource);
                this.resourceDeletionIgnored = false;
            }
            if (!Objects.equals(oldData, this.data)) {
                for (XdsClient.ResourceWatcher<T> watcher : this.watchers.keySet()) {
                    processingTracker.startTask();
                    this.watchers.get(watcher).execute(() -> {
                        try {
                            this.notifyWatcher(watcher, this.data);
                        }
                        finally {
                            processingTracker.onComplete();
                        }
                    });
                }
            }
        }

        private String getTarget() {
            ControlPlaneClient activeCpc = XdsClientImpl.this.getActiveCpc(this.authority);
            return activeCpc != null ? activeCpc.getServerInfo().target() : "unknown";
        }

        void onAbsent(@Nullable XdsClient.ProcessingTracker processingTracker, Bootstrapper.ServerInfo serverInfo) {
            if (this.respTimer != null && this.respTimer.isPending()) {
                return;
            }
            boolean ignoreResourceDeletionEnabled = serverInfo.ignoreResourceDeletion();
            if (ignoreResourceDeletionEnabled && this.type.isFullStateOfTheWorld() && this.data != null) {
                if (!this.resourceDeletionIgnored) {
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.FORCE_WARNING, "xds server {0}: ignoring deletion for resource type {1} name {2}}", serverInfo.target(), this.type, this.resource);
                    this.resourceDeletionIgnored = true;
                }
                return;
            }
            XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Conclude {0} resource {1} not exist", this.type, this.resource);
            if (!this.absent) {
                this.data = null;
                this.absent = true;
                this.metadata = XdsClient.ResourceMetadata.newResourceMetadataDoesNotExist();
                for (XdsClient.ResourceWatcher<T> watcher : this.watchers.keySet()) {
                    if (processingTracker != null) {
                        processingTracker.startTask();
                    }
                    this.watchers.get(watcher).execute(() -> {
                        try {
                            watcher.onResourceDoesNotExist(this.resource);
                        }
                        finally {
                            if (processingTracker != null) {
                                processingTracker.onComplete();
                            }
                        }
                    });
                }
            }
        }

        void onError(Status error, @Nullable XdsClient.ProcessingTracker tracker) {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
            String description = error.getDescription() == null ? "" : error.getDescription() + " ";
            Status errorAugmented = Status.fromCode(error.getCode()).withDescription(description + "nodeID: " + XdsClientImpl.this.bootstrapInfo.node().getId()).withCause(error.getCause());
            for (XdsClient.ResourceWatcher watcher : this.watchers.keySet()) {
                if (tracker != null) {
                    tracker.startTask();
                }
                this.watchers.get(watcher).execute(() -> {
                    try {
                        watcher.onError(errorAugmented);
                    }
                    finally {
                        if (tracker != null) {
                            tracker.onComplete();
                        }
                    }
                });
            }
        }

        void onRejected(String rejectedVersion, long rejectedTime, String rejectedDetails) {
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataNacked(this.metadata, rejectedVersion, rejectedTime, rejectedDetails, this.data != null);
        }

        private void notifyWatcher(XdsClient.ResourceWatcher<T> watcher, T update) {
            watcher.onChanged(update);
        }
    }
}

