/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.NoOpConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestTestUtils;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConsumerMetadataTest {
    private final Node node = new Node(1, "localhost", 9092);
    private final SubscriptionState subscription = new SubscriptionState(new LogContext(), OffsetResetStrategy.EARLIEST);
    private final Time time = new MockTime();

    @Test
    public void testPatternSubscriptionNoInternalTopics() {
        this.testPatternSubscription(false);
    }

    @Test
    public void testPatternSubscriptionIncludeInternalTopics() {
        this.testPatternSubscription(true);
    }

    private void testPatternSubscription(boolean includeInternalTopics) {
        this.subscription.subscribe(Pattern.compile("__.*"), (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
        ConsumerMetadata metadata = this.newConsumerMetadata(includeInternalTopics);
        MetadataRequest.Builder builder = metadata.newMetadataRequestBuilder();
        Assertions.assertTrue((boolean)builder.isAllTopics());
        ArrayList<MetadataResponse.TopicMetadata> topics = new ArrayList<MetadataResponse.TopicMetadata>();
        topics.add(this.topicMetadata("__consumer_offsets", true));
        topics.add(this.topicMetadata("__matching_topic", false));
        topics.add(this.topicMetadata("non_matching_topic", false));
        MetadataResponse response = RequestTestUtils.metadataResponse(Collections.singletonList(this.node), "clusterId", this.node.id(), topics);
        metadata.updateWithCurrentRequestVersion(response, false, this.time.milliseconds());
        if (includeInternalTopics) {
            Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"__matching_topic", "__consumer_offsets"}), (Object)metadata.fetch().topics());
        } else {
            Assertions.assertEquals(Collections.singleton("__matching_topic"), (Object)metadata.fetch().topics());
        }
    }

    @Test
    public void testUserAssignment() {
        this.subscription.assignFromUser(Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("bar", 0), new TopicPartition("__consumer_offsets", 0)}));
        this.testBasicSubscription(Utils.mkSet((Object[])new String[]{"foo", "bar"}), Utils.mkSet((Object[])new String[]{"__consumer_offsets"}));
        this.subscription.assignFromUser(Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("baz", 0), new TopicPartition("__consumer_offsets", 0)}));
        this.testBasicSubscription(Utils.mkSet((Object[])new String[]{"baz"}), Utils.mkSet((Object[])new String[]{"__consumer_offsets"}));
    }

    @Test
    public void testNormalSubscription() {
        this.subscription.subscribe(Utils.mkSet((Object[])new String[]{"foo", "bar", "__consumer_offsets"}), (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
        this.subscription.groupSubscribe((Collection)Utils.mkSet((Object[])new String[]{"baz", "foo", "bar", "__consumer_offsets"}));
        this.testBasicSubscription(Utils.mkSet((Object[])new String[]{"foo", "bar", "baz"}), Utils.mkSet((Object[])new String[]{"__consumer_offsets"}));
        this.subscription.resetGroupSubscription();
        this.testBasicSubscription(Utils.mkSet((Object[])new String[]{"foo", "bar"}), Utils.mkSet((Object[])new String[]{"__consumer_offsets"}));
    }

    @Test
    public void testTransientTopics() {
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put("foo", Uuid.randomUuid());
        this.subscription.subscribe(Collections.singleton("foo"), (ConsumerRebalanceListener)new NoOpConsumerRebalanceListener());
        ConsumerMetadata metadata = this.newConsumerMetadata(false);
        metadata.updateWithCurrentRequestVersion(RequestTestUtils.metadataUpdateWithIds(1, Collections.singletonMap("foo", 1), topicIds), false, this.time.milliseconds());
        Assertions.assertEquals(topicIds.get("foo"), metadata.topicIds().get("foo"));
        Assertions.assertFalse((boolean)metadata.updateRequested());
        metadata.addTransientTopics(Collections.singleton("foo"));
        Assertions.assertFalse((boolean)metadata.updateRequested());
        metadata.addTransientTopics(Collections.singleton("bar"));
        Assertions.assertTrue((boolean)metadata.updateRequested());
        HashMap<String, Integer> topicPartitionCounts = new HashMap<String, Integer>();
        topicPartitionCounts.put("foo", 1);
        topicPartitionCounts.put("bar", 1);
        topicIds.put("bar", Uuid.randomUuid());
        metadata.updateWithCurrentRequestVersion(RequestTestUtils.metadataUpdateWithIds(1, topicPartitionCounts, topicIds), false, this.time.milliseconds());
        Map metadataTopicIds = metadata.topicIds();
        topicIds.forEach((topicName, topicId) -> Assertions.assertEquals((Object)topicId, metadataTopicIds.get(topicName)));
        Assertions.assertFalse((boolean)metadata.updateRequested());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"foo", "bar"}), new HashSet(metadata.fetch().topics()));
        metadata.clearTransientTopics();
        topicIds.remove("bar");
        metadata.updateWithCurrentRequestVersion(RequestTestUtils.metadataUpdateWithIds(1, topicPartitionCounts, topicIds), false, this.time.milliseconds());
        Assertions.assertEquals(Collections.singleton("foo"), new HashSet(metadata.fetch().topics()));
        Assertions.assertEquals(topicIds.get("foo"), metadata.topicIds().get("foo"));
        Assertions.assertEquals(topicIds.get("bar"), null);
    }

    private void testBasicSubscription(Set<String> expectedTopics, Set<String> expectedInternalTopics) {
        HashSet<String> allTopics = new HashSet<String>();
        allTopics.addAll(expectedTopics);
        allTopics.addAll(expectedInternalTopics);
        ConsumerMetadata metadata = this.newConsumerMetadata(false);
        MetadataRequest.Builder builder = metadata.newMetadataRequestBuilder();
        Assertions.assertEquals(allTopics, new HashSet(builder.topics()));
        ArrayList<MetadataResponse.TopicMetadata> topics = new ArrayList<MetadataResponse.TopicMetadata>();
        for (String expectedTopic : expectedTopics) {
            topics.add(this.topicMetadata(expectedTopic, false));
        }
        for (String expectedInternalTopic : expectedInternalTopics) {
            topics.add(this.topicMetadata(expectedInternalTopic, true));
        }
        MetadataResponse response = RequestTestUtils.metadataResponse(Collections.singletonList(this.node), "clusterId", this.node.id(), topics);
        metadata.updateWithCurrentRequestVersion(response, false, this.time.milliseconds());
        Assertions.assertEquals(allTopics, (Object)metadata.fetch().topics());
    }

    private MetadataResponse.TopicMetadata topicMetadata(String topic, boolean isInternal) {
        MetadataResponse.PartitionMetadata partitionMetadata = new MetadataResponse.PartitionMetadata(Errors.NONE, new TopicPartition(topic, 0), Optional.of(this.node.id()), Optional.of(5), Collections.singletonList(this.node.id()), Collections.singletonList(this.node.id()), Collections.singletonList(this.node.id()));
        return new MetadataResponse.TopicMetadata(Errors.NONE, topic, isInternal, Collections.singletonList(partitionMetadata));
    }

    private ConsumerMetadata newConsumerMetadata(boolean includeInternalTopics) {
        long refreshBackoffMs = 50L;
        long expireMs = 50000L;
        return new ConsumerMetadata(refreshBackoffMs, expireMs, includeInternalTopics, false, this.subscription, new LogContext(), new ClusterResourceListeners());
    }
}

