/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.org.jboss.netty.handler.ipfilter;

import java.net.InetSocketAddress;
import org.apache.kudu.shaded.org.jboss.netty.channel.ChannelEvent;
import org.apache.kudu.shaded.org.jboss.netty.channel.ChannelFuture;
import org.apache.kudu.shaded.org.jboss.netty.channel.ChannelFutureListener;
import org.apache.kudu.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.kudu.shaded.org.jboss.netty.channel.ChannelStateEvent;
import org.apache.kudu.shaded.org.jboss.netty.channel.ChannelUpstreamHandler;
import org.apache.kudu.shaded.org.jboss.netty.channel.Channels;
import org.apache.kudu.shaded.org.jboss.netty.handler.ipfilter.IpFilterListener;
import org.apache.kudu.shaded.org.jboss.netty.handler.ipfilter.IpFilteringHandler;

public abstract class IpFilteringHandlerImpl
implements ChannelUpstreamHandler,
IpFilteringHandler {
    private IpFilterListener listener;

    protected abstract boolean accept(ChannelHandlerContext var1, ChannelEvent var2, InetSocketAddress var3) throws Exception;

    protected ChannelFuture handleRefusedChannel(ChannelHandlerContext ctx, ChannelEvent e, InetSocketAddress inetSocketAddress) throws Exception {
        if (this.listener == null) {
            return null;
        }
        return this.listener.refused(ctx, e, inetSocketAddress);
    }

    protected ChannelFuture handleAllowedChannel(ChannelHandlerContext ctx, ChannelEvent e, InetSocketAddress inetSocketAddress) throws Exception {
        if (this.listener == null) {
            return null;
        }
        return this.listener.allowed(ctx, e, inetSocketAddress);
    }

    protected boolean isBlocked(ChannelHandlerContext ctx) {
        return ctx.getAttachment() != null;
    }

    protected boolean continues(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (this.listener != null) {
            return this.listener.continues(ctx, e);
        }
        return false;
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent evt = (ChannelStateEvent)e;
            switch (evt.getState()) {
                case OPEN: 
                case BOUND: {
                    if (evt.getValue() != Boolean.TRUE) {
                        ctx.sendUpstream(e);
                        return;
                    }
                    if (this.isBlocked(ctx) && !this.continues(ctx, evt)) {
                        return;
                    }
                    ctx.sendUpstream(e);
                    return;
                }
                case CONNECTED: {
                    if (evt.getValue() != null) {
                        InetSocketAddress inetSocketAddress = (InetSocketAddress)e.getChannel().getRemoteAddress();
                        if (!this.accept(ctx, e, inetSocketAddress)) {
                            ctx.setAttachment(Boolean.TRUE);
                            ChannelFuture future = this.handleRefusedChannel(ctx, e, inetSocketAddress);
                            if (future != null) {
                                future.addListener(ChannelFutureListener.CLOSE);
                            } else {
                                Channels.close(e.getChannel());
                            }
                            if (this.isBlocked(ctx) && !this.continues(ctx, evt)) {
                                return;
                            }
                        } else {
                            this.handleAllowedChannel(ctx, e, inetSocketAddress);
                        }
                        ctx.setAttachment(null);
                        break;
                    }
                    if (!this.isBlocked(ctx) || this.continues(ctx, evt)) break;
                    return;
                }
            }
        }
        if (this.isBlocked(ctx) && !this.continues(ctx, e)) {
            return;
        }
        ctx.sendUpstream(e);
    }

    public void setIpFilterListener(IpFilterListener listener) {
        this.listener = listener;
    }

    public void removeIpFilterListener() {
        this.listener = null;
    }
}

