/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.resources;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugins.resources.AbstractPropertyUtilsTest;
import org.apache.maven.shared.filtering.PropertyUtils;

public class BasicPropertyUtilsTest
extends AbstractPropertyUtilsTest {
    protected static final String validationFileName = "/target/test-classes/unit/propertiesutils-test/basic_validation.properties";
    protected static final String propFileName = "/target/test-classes/unit/propertiesutils-test/basic.properties";

    @Override
    protected File getPropertyFile() {
        File propFile = new File(BasicPropertyUtilsTest.getBasedir(), propFileName);
        if (!propFile.exists()) {
            propFile = null;
        }
        return propFile;
    }

    @Override
    protected File getValidationFile() {
        File validationFile = new File(BasicPropertyUtilsTest.getBasedir(), validationFileName);
        if (!validationFile.exists()) {
            validationFile = null;
        }
        return validationFile;
    }

    public void testBasicLoadProperty_FF() throws Exception {
        Properties prop = PropertyUtils.loadPropertyFile((File)this.propertyFile, (boolean)false, (boolean)false);
        BasicPropertyUtilsTest.assertNotNull((Object)prop);
        BasicPropertyUtilsTest.assertTrue((boolean)this.validateProperties(prop));
    }

    public void testBasicLoadProperty_TF() throws Exception {
        Properties prop = PropertyUtils.loadPropertyFile((File)this.propertyFile, (boolean)true, (boolean)false);
        BasicPropertyUtilsTest.assertNotNull((Object)prop);
        BasicPropertyUtilsTest.assertTrue((boolean)this.validateProperties(prop));
    }

    public void testBasicLoadProperty_TT() throws Exception {
        Properties prop = PropertyUtils.loadPropertyFile((File)this.propertyFile, (boolean)true, (boolean)true);
        this.validationProp.putAll((Map<?, ?>)System.getProperties());
        BasicPropertyUtilsTest.assertNotNull((Object)prop);
        BasicPropertyUtilsTest.assertTrue((boolean)this.validateProperties(prop));
    }

    public void testNonExistentProperty() throws Exception {
        Properties prop = PropertyUtils.loadPropertyFile((File)this.propertyFile, (boolean)true, (boolean)true);
        this.validationProp.putAll((Map<?, ?>)System.getProperties());
        BasicPropertyUtilsTest.assertNotNull((Object)prop);
        BasicPropertyUtilsTest.assertNull((Object)prop.getProperty("does_not_exist"));
    }
}

