/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.resources;

import java.io.File;
import java.util.Collections;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.testing.AbstractMojoTestCase;
import org.apache.maven.plugins.resources.ResourcesMojo;
import org.apache.maven.plugins.resources.stub.MavenProjectResourcesStub;
import org.codehaus.plexus.util.FileUtils;

public class CopyResourcesMojoTest
extends AbstractMojoTestCase {
    protected static final String defaultPomFilePath = "/target/test-classes/unit/resources-test/plugin-config.xml";
    File outputDirectory = new File(CopyResourcesMojoTest.getBasedir(), "/target/copyResourcesTests");

    protected void setUp() throws Exception {
        super.setUp();
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        } else {
            FileUtils.cleanDirectory((File)this.outputDirectory);
        }
    }

    public void testCopyWithoutFiltering() throws Exception {
        File testPom = new File(CopyResourcesMojoTest.getBasedir(), defaultPomFilePath);
        ResourcesMojo mojo = (ResourcesMojo)this.lookupMojo("resources", testPom);
        mojo.setOutputDirectory(this.outputDirectory);
        Resource resource = new Resource();
        resource.setDirectory(CopyResourcesMojoTest.getBasedir() + "/src/test/unit-files/copy-resources-test/no-filter");
        resource.setFiltering(false);
        mojo.setResources(Collections.singletonList(resource));
        MavenProjectResourcesStub project = new MavenProjectResourcesStub("CopyResourcesMojoTest");
        File targetFile = new File(CopyResourcesMojoTest.getBasedir(), "/target/copyResourcesTests");
        project.setBaseDir(targetFile);
        this.setVariableValueToObject(mojo, "project", (Object)project);
        mojo.execute();
        CopyResourcesMojoTest.assertTrue((boolean)new File(targetFile, "config.properties").exists());
    }
}

