/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.resources.stub;

import java.io.File;
import org.apache.maven.model.Resource;
import org.apache.maven.plugins.resources.stub.MavenProjectBuildStub;

public class MavenProjectResourcesStub
extends MavenProjectBuildStub {
    private File baseDir;

    public MavenProjectResourcesStub(String id) throws Exception {
        super(id);
        this.setupResources();
        this.setupTestResources();
    }

    public void addInclude(String pattern) {
        ((Resource)this.build.getResources().get(0)).addInclude(pattern);
    }

    public void addExclude(String pattern) {
        ((Resource)this.build.getResources().get(0)).addExclude(pattern);
    }

    public void addTestInclude(String pattern) {
        ((Resource)this.build.getTestResources().get(0)).addInclude(pattern);
    }

    public void addTestExclude(String pattern) {
        ((Resource)this.build.getTestResources().get(0)).addExclude(pattern);
    }

    public void setTargetPath(String path) {
        ((Resource)this.build.getResources().get(0)).setTargetPath(path);
    }

    public void setTestTargetPath(String path) {
        ((Resource)this.build.getTestResources().get(0)).setTargetPath(path);
    }

    public void setDirectory(String dir) {
        ((Resource)this.build.getResources().get(0)).setDirectory(dir);
    }

    public void setTestDirectory(String dir) {
        ((Resource)this.build.getTestResources().get(0)).setDirectory(dir);
    }

    public void setResourceFiltering(int nIndex, boolean filter) {
        if (this.build.getResources().size() > nIndex) {
            ((Resource)this.build.getResources().get(nIndex)).setFiltering(filter);
        }
    }

    private void setupResources() {
        Resource resource = new Resource();
        resource.setDirectory(this.getBasedir().getPath() + "/src/main/resources");
        resource.setFiltering(false);
        resource.setTargetPath(null);
        this.build.addResource(resource);
    }

    private void setupTestResources() {
        Resource resource = new Resource();
        resource.setDirectory(this.getBasedir().getPath() + "/src/test/resources");
        resource.setFiltering(false);
        resource.setTargetPath(null);
        this.build.addTestResource(resource);
    }

    public File getBaseDir() {
        return this.baseDir == null ? super.getBasedir() : this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }
}

