/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.activation.DataSource;
import org.apache.cxf.message.Attachment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyDataSource
implements DataSource {
    private DataSource dataSource;
    private Collection<Attachment> attachments;
    private String id;

    public LazyDataSource(String id, Collection<Attachment> attachments) {
        this.id = id;
        this.attachments = attachments;
    }

    private synchronized void load() {
        if (this.dataSource == null) {
            for (Attachment a : this.attachments) {
                if (!a.getId().equals(this.id)) continue;
                this.dataSource = a.getDataHandler().getDataSource();
                break;
            }
        }
        if (this.dataSource == null) {
            ArrayList<String> ids = new ArrayList<String>(10);
            for (Attachment a : this.attachments) {
                ids.add(a.getId());
                if (!a.getId().equals(this.id)) continue;
                this.dataSource = a.getDataHandler().getDataSource();
                if (this.dataSource != null) {
                    ids = null;
                    break;
                }
                throw new IllegalStateException("Could not get DataSource for attachment of id " + this.id);
            }
            if (ids != null) {
                throw new IllegalStateException("No attachment for  id " + this.id + " found in " + ids);
            }
        }
    }

    public String getContentType() {
        this.load();
        return this.dataSource.getContentType();
    }

    public InputStream getInputStream() throws IOException {
        this.load();
        return this.dataSource.getInputStream();
    }

    public String getName() {
        this.load();
        return this.dataSource.getName();
    }

    public OutputStream getOutputStream() throws IOException {
        this.load();
        return this.dataSource.getOutputStream();
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

