/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.CorbaBindingException;
import org.apache.cxf.binding.corba.CorbaStreamable;
import org.apache.cxf.binding.corba.CorbaTypeMap;
import org.apache.cxf.binding.corba.runtime.CorbaStreamableImpl;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.message.AbstractWrappedMessage;
import org.apache.cxf.message.Message;
import org.omg.CORBA.NVList;
import org.omg.CORBA.SystemException;

public class CorbaMessage
extends AbstractWrappedMessage {
    private List<CorbaStreamable> arguments;
    private CorbaStreamable returnParam;
    private CorbaStreamable except;
    private SystemException systemExcept;
    private CorbaTypeMap corbaTypeMap;
    private NVList list;

    public CorbaMessage(Message m) {
        super(m);
        if (m instanceof CorbaMessage) {
            CorbaMessage msg = (CorbaMessage)m;
            CorbaStreamable[] data = msg.getStreamableArguments();
            this.setStreamableArguments(data);
            this.returnParam = msg.getStreamableReturn();
            this.except = msg.getStreamableException();
            this.systemExcept = msg.getSystemException();
            this.list = msg.getList();
            this.corbaTypeMap = msg.getCorbaTypeMap();
        } else {
            this.arguments = new ArrayList<CorbaStreamable>();
        }
    }

    public void setList(NVList lst) {
        this.list = lst;
    }

    public NVList getList() {
        return this.list;
    }

    public CorbaStreamable getStreamableException() {
        return this.except;
    }

    public CorbaStreamable getStreamableReturn() {
        return this.returnParam;
    }

    public SystemException getSystemException() {
        return this.systemExcept;
    }

    public void setSystemException(SystemException sysEx) {
        this.systemExcept = sysEx;
    }

    public final void addStreamableArgument(CorbaStreamable arg) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<CorbaStreamable>(1);
        }
        this.arguments.add(arg);
    }

    public CorbaStreamable[] getStreamableArguments() {
        return this.arguments.toArray(new CorbaStreamable[0]);
    }

    public final void setStreamableArguments(CorbaStreamable[] data) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<CorbaStreamable>(data.length);
        }
        for (CorbaStreamable streamable : data) {
            this.addStreamableArgument(streamable);
        }
    }

    public void setStreamableArgumentValue(CorbaObjectHandler data, int idx) {
        if (idx >= this.arguments.size()) {
            throw new CorbaBindingException("setStreamableArgumentValue: Index out of range");
        }
        this.arguments.get(idx).setObject(data);
    }

    public void setStreamableArgumentValues(CorbaObjectHandler[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.arguments.get(i).setObject(data[i]);
        }
    }

    public void setStreamableReturn(CorbaStreamable data) {
        this.returnParam = data;
    }

    public void setStreamableReturnValue(CorbaObjectHandler data) {
        this.returnParam.setObject(data);
    }

    public void setStreamableException(CorbaStreamable ex) {
        this.except = ex;
    }

    public void setStreamableExceptionValue(CorbaObjectHandler exData) {
        this.except.setObject(exData);
    }

    public CorbaStreamable createStreamableObject(CorbaObjectHandler obj, QName elName) {
        return new CorbaStreamableImpl(obj, elName);
    }

    public CorbaTypeMap getCorbaTypeMap() {
        return this.corbaTypeMap;
    }

    public void setCorbaTypeMap(CorbaTypeMap typeMap) {
        this.corbaTypeMap = typeMap;
    }
}

