/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.openjpa.lib.jdbc.DelegatingResultSet;
import org.apache.openjpa.lib.util.Closeable;

public class DelegatingStatement
implements Statement,
Closeable {
    private Statement _stmnt;
    private DelegatingStatement _del;
    private Connection _conn;

    public DelegatingStatement(Statement stmnt, Connection conn) {
        this.initialize(stmnt, conn);
    }

    public void initialize(Statement stmnt, Connection conn) {
        this._conn = conn;
        this._stmnt = stmnt;
        this._del = stmnt instanceof DelegatingStatement ? (DelegatingStatement)stmnt : null;
    }

    protected ResultSet wrapResult(ResultSet rs, boolean wrap) {
        if (!wrap || rs == null) {
            return rs;
        }
        return new DelegatingResultSet(rs, this);
    }

    public Statement getDelegate() {
        return this._stmnt;
    }

    public Statement getInnermostDelegate() {
        return this._del == null ? this._stmnt : this._del.getInnermostDelegate();
    }

    public int hashCode() {
        return this.getInnermostDelegate().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof DelegatingStatement) {
            other = ((DelegatingStatement)other).getInnermostDelegate();
        }
        return this.getInnermostDelegate().equals(other);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("stmnt ").append(this.hashCode());
        this.appendInfo(buf);
        return buf.toString();
    }

    protected void appendInfo(StringBuffer buf) {
        if (this._del != null) {
            this._del.appendInfo(buf);
        }
    }

    @Override
    public ResultSet executeQuery(String str) throws SQLException {
        return this.executeQuery(str, true);
    }

    protected ResultSet executeQuery(String sql, boolean wrap) throws SQLException {
        ResultSet rs = this._del != null ? this._del.executeQuery(sql, false) : this._stmnt.executeQuery(sql);
        return this.wrapResult(rs, wrap);
    }

    @Override
    public int executeUpdate(String str) throws SQLException {
        return this._stmnt.executeUpdate(str);
    }

    @Override
    public boolean execute(String str) throws SQLException {
        return this._stmnt.execute(str);
    }

    @Override
    public void close() throws SQLException {
        this._stmnt.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this._stmnt.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int i) throws SQLException {
        this._stmnt.setMaxFieldSize(i);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this._stmnt.getMaxRows();
    }

    @Override
    public void setMaxRows(int i) throws SQLException {
        this._stmnt.setMaxRows(i);
    }

    @Override
    public void setEscapeProcessing(boolean bool) throws SQLException {
        this._stmnt.setEscapeProcessing(bool);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this._stmnt.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int i) throws SQLException {
        this._stmnt.setQueryTimeout(i);
    }

    @Override
    public void cancel() throws SQLException {
        this._stmnt.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._stmnt.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this._stmnt.clearWarnings();
    }

    @Override
    public void setCursorName(String str) throws SQLException {
        this._stmnt.setCursorName(str);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet(true);
    }

    protected ResultSet getResultSet(boolean wrap) throws SQLException {
        ResultSet rs = this._del != null ? this._del.getResultSet(false) : this._stmnt.getResultSet();
        return this.wrapResult(rs, wrap);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this._stmnt.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this._stmnt.getMoreResults();
    }

    @Override
    public void setFetchDirection(int i) throws SQLException {
        this._stmnt.setFetchDirection(i);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this._stmnt.getFetchDirection();
    }

    @Override
    public void setFetchSize(int i) throws SQLException {
        this._stmnt.setFetchSize(i);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this._stmnt.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this._stmnt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this._stmnt.getResultSetType();
    }

    @Override
    public void addBatch(String str) throws SQLException {
        this._stmnt.addBatch(str);
    }

    @Override
    public void clearBatch() throws SQLException {
        this._stmnt.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this._stmnt.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._conn;
    }

    @Override
    public boolean getMoreResults(int i) throws SQLException {
        return this._stmnt.getMoreResults(i);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this._stmnt.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String s, int i) throws SQLException {
        return this._stmnt.executeUpdate(s, i);
    }

    @Override
    public int executeUpdate(String s, int[] ia) throws SQLException {
        return this._stmnt.executeUpdate(s, ia);
    }

    @Override
    public int executeUpdate(String s, String[] sa) throws SQLException {
        return this._stmnt.executeUpdate(s, sa);
    }

    @Override
    public boolean execute(String s, int i) throws SQLException {
        return this._stmnt.execute(s, i);
    }

    @Override
    public boolean execute(String s, int[] ia) throws SQLException {
        return this._stmnt.execute(s, ia);
    }

    @Override
    public boolean execute(String s, String[] sa) throws SQLException {
        return this._stmnt.execute(s, sa);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this._stmnt.getResultSetHoldability();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getDelegate().getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this.getDelegate();
        }
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._stmnt.isClosed();
    }

    @Override
    public void setPoolable(boolean b) throws SQLException {
        this._stmnt.setPoolable(b);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this._stmnt.isPoolable();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException();
    }
}

