/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.read;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.parquet.read.DataWritableReadSupport;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.hive.HiveBinding;
import org.apache.parquet.hive.HiveBindingFactory;
import org.apache.parquet.schema.MessageTypeParser;

public class ParquetRecordReaderWrapper
implements org.apache.hadoop.mapred.RecordReader<Void, ArrayWritable> {
    public static final Log LOG = LogFactory.getLog(ParquetRecordReaderWrapper.class);
    private final long splitLen;
    private RecordReader<Void, ArrayWritable> realReader;
    private ArrayWritable valueObj = null;
    private boolean firstRecord = false;
    private boolean eof = false;
    private int schemaSize;
    private final HiveBinding hiveBinding;

    public ParquetRecordReaderWrapper(ParquetInputFormat<ArrayWritable> newInputFormat, org.apache.hadoop.mapred.InputSplit oldSplit, JobConf oldJobConf, Reporter reporter) throws IOException, InterruptedException {
        this(newInputFormat, oldSplit, oldJobConf, reporter, new HiveBindingFactory().create());
    }

    public ParquetRecordReaderWrapper(ParquetInputFormat<ArrayWritable> newInputFormat, org.apache.hadoop.mapred.InputSplit oldSplit, JobConf oldJobConf, Reporter reporter, HiveBinding hiveBinding) throws IOException, InterruptedException {
        this.splitLen = oldSplit.getLength();
        this.hiveBinding = hiveBinding;
        ParquetInputSplit split = this.getSplit(oldSplit, oldJobConf);
        TaskAttemptID taskAttemptID = TaskAttemptID.forName((String)oldJobConf.get("mapred.task.id"));
        if (taskAttemptID == null) {
            taskAttemptID = new TaskAttemptID();
        }
        TaskAttemptContext taskContext = ContextUtil.newTaskAttemptContext((Configuration)oldJobConf, taskAttemptID);
        if (split != null) {
            try {
                this.realReader = newInputFormat.createRecordReader((InputSplit)split, taskContext);
                this.realReader.initialize((InputSplit)split, taskContext);
                if (this.realReader.nextKeyValue()) {
                    this.firstRecord = true;
                    this.valueObj = (ArrayWritable)this.realReader.getCurrentValue();
                }
                this.eof = true;
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        } else {
            this.realReader = null;
            this.eof = true;
        }
        if (this.valueObj == null) {
            this.valueObj = new ArrayWritable(Writable.class, new Writable[this.schemaSize]);
        }
    }

    public void close() throws IOException {
        if (this.realReader != null) {
            this.realReader.close();
        }
    }

    public Void createKey() {
        return null;
    }

    public ArrayWritable createValue() {
        return this.valueObj;
    }

    public long getPos() throws IOException {
        return (long)((float)this.splitLen * this.getProgress());
    }

    public float getProgress() throws IOException {
        if (this.realReader == null) {
            return 1.0f;
        }
        try {
            return this.realReader.getProgress();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public boolean next(Void key, ArrayWritable value) throws IOException {
        if (this.eof) {
            return false;
        }
        try {
            if (this.firstRecord) {
                this.firstRecord = false;
            } else if (!this.realReader.nextKeyValue()) {
                this.eof = true;
                return false;
            }
            ArrayWritable tmpCurValue = (ArrayWritable)this.realReader.getCurrentValue();
            if (value != tmpCurValue) {
                Writable[] arrValue = value.get();
                Writable[] arrCurrent = tmpCurValue.get();
                if (value != null && arrValue.length == arrCurrent.length) {
                    System.arraycopy(arrCurrent, 0, arrValue, 0, arrCurrent.length);
                } else {
                    if (arrValue.length != arrCurrent.length) {
                        throw new IOException("DeprecatedParquetHiveInput : size of object differs. Value size :  " + arrValue.length + ", Current Object size : " + arrCurrent.length);
                    }
                    throw new IOException("DeprecatedParquetHiveInput can not support RecordReaders that don't return same key & value & value is null");
                }
            }
            return true;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    protected ParquetInputSplit getSplit(org.apache.hadoop.mapred.InputSplit oldSplit, JobConf conf) throws IOException {
        if (oldSplit instanceof FileSplit) {
            FileSplit fileSplit = (FileSplit)oldSplit;
            long splitStart = fileSplit.getStart();
            long splitLength = fileSplit.getLength();
            Path finalPath = fileSplit.getPath();
            JobConf cloneJob = this.hiveBinding.pushProjectionsAndFilters(conf, finalPath.getParent());
            ParquetMetadata parquetMetadata = ParquetFileReader.readFooter((Configuration)cloneJob, finalPath, ParquetMetadataConverter.SKIP_ROW_GROUPS);
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            ReadSupport.ReadContext readContext = new DataWritableReadSupport().init((Configuration)cloneJob, fileMetaData.getKeyValueMetaData(), fileMetaData.getSchema());
            this.schemaSize = MessageTypeParser.parseMessageType(readContext.getReadSupportMetadata().get("HIVE_TABLE_SCHEMA")).getFieldCount();
            return new ParquetInputSplit(finalPath, splitStart, splitStart + splitLength, splitLength, fileSplit.getLocations(), null);
        }
        throw new IllegalArgumentException("Unknown split type: " + oldSplit);
    }
}

