/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.writable;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.parquet.io.api.Binary;

public class BinaryWritable
implements Writable {
    private Binary binary;

    public BinaryWritable(Binary binary) {
        this.binary = binary;
    }

    public Binary getBinary() {
        return this.binary;
    }

    public byte[] getBytes() {
        return this.binary.getBytes();
    }

    public String getString() {
        return this.binary.toStringUsingUTF8();
    }

    public void readFields(DataInput input) throws IOException {
        byte[] bytes = new byte[input.readInt()];
        input.readFully(bytes);
        this.binary = Binary.fromByteArray(bytes);
    }

    public void write(DataOutput output) throws IOException {
        output.writeInt(this.binary.length());
        this.binary.writeTo(output);
    }

    public int hashCode() {
        return this.binary == null ? 0 : this.binary.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BinaryWritable) {
            BinaryWritable other = (BinaryWritable)obj;
            return this.binary.equals((Object)other.binary);
        }
        return false;
    }

    public static class DicBinaryWritable
    extends BinaryWritable {
        private final String string;

        public DicBinaryWritable(Binary binary, String string) {
            super(binary);
            this.string = string;
        }

        @Override
        public String getString() {
            return this.string;
        }
    }
}

