/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hive.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.Log;
import org.apache.parquet.hive.internal.AbstractHiveBinding;

public class Hive012Binding
extends AbstractHiveBinding {
    private static final Log LOG = Log.getLog(Hive012Binding.class);
    private final Map<String, PartitionDesc> pathToPartitionInfo = new LinkedHashMap<String, PartitionDesc>();
    private MapWork mapWork;

    private void init(JobConf job) {
        String plan = HiveConf.getVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.PLAN);
        if (this.mapWork == null && plan != null && plan.length() > 0) {
            this.mapWork = Utilities.getMapWork((Configuration)job);
            this.pathToPartitionInfo.clear();
            for (Map.Entry entry : this.mapWork.getPathToPartitionInfo().entrySet()) {
                this.pathToPartitionInfo.put(new Path((String)entry.getKey()).toUri().getPath().toString(), (PartitionDesc)entry.getValue());
            }
        }
    }

    private void pushProjectionsAndFilters(JobConf jobConf, String splitPath, String splitPathWithNoSchema) {
        if (this.mapWork == null) {
            LOG.debug("Not pushing projections and filters because MapWork is null");
            return;
        }
        if (this.mapWork.getPathToAliases() == null) {
            LOG.debug("Not pushing projections and filters because pathToAliases is null");
            return;
        }
        ArrayList<String> aliases = new ArrayList<String>();
        for (Map.Entry entry : this.mapWork.getPathToAliases().entrySet()) {
            String key = new Path((String)entry.getKey()).toUri().getPath();
            if (!splitPath.equals(key) && !splitPathWithNoSchema.equals(key)) continue;
            ArrayList list = (ArrayList)entry.getValue();
            for (String val : list) {
                aliases.add(val);
            }
        }
        for (String alias : aliases) {
            Operator op = (Operator)this.mapWork.getAliasToWork().get(alias);
            if (op == null || !(op instanceof TableScanOperator)) continue;
            TableScanOperator tableScan = (TableScanOperator)op;
            ArrayList list = tableScan.getNeededColumnIDs();
            if (list != null) {
                ColumnProjectionUtils.appendReadColumnIDs((Configuration)jobConf, (List)list);
            } else {
                ColumnProjectionUtils.setFullyReadColumns((Configuration)jobConf);
            }
            this.pushFilters(jobConf, tableScan);
        }
    }

    private void pushFilters(JobConf jobConf, TableScanOperator tableScan) {
        TableScanDesc scanDesc = (TableScanDesc)tableScan.getConf();
        if (scanDesc == null) {
            LOG.debug("Not pushing filters because TableScanDesc is null");
            return;
        }
        Utilities.setColumnNameList((JobConf)jobConf, (Operator)tableScan);
        ExprNodeDesc filterExpr = scanDesc.getFilterExpr();
        if (filterExpr == null) {
            LOG.debug("Not pushing filters because FilterExpr is null");
            return;
        }
        String filterText = filterExpr.getExprString();
        String filterExprSerialized = Utilities.serializeExpression((ExprNodeDesc)filterExpr);
        jobConf.set("hive.io.filter.text", filterText);
        jobConf.set("hive.io.filter.expr.serialized", filterExprSerialized);
    }

    @Override
    public JobConf pushProjectionsAndFilters(JobConf jobConf, Path path) throws IOException {
        this.init(jobConf);
        JobConf cloneJobConf = new JobConf((Configuration)jobConf);
        PartitionDesc part = this.pathToPartitionInfo.get(path.toString());
        if (part != null && part.getTableDesc() != null) {
            Utilities.copyTableJobPropertiesToConf((TableDesc)part.getTableDesc(), (JobConf)cloneJobConf);
        }
        this.pushProjectionsAndFilters(cloneJobConf, path.toString(), path.toUri().toString());
        return cloneJobConf;
    }
}

