/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.pig.convert;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.pig.PigSchemaConverter;
import org.apache.parquet.pig.SchemaConversionException;
import org.apache.parquet.pig.convert.ParentValueContainer;
import org.apache.parquet.pig.convert.TupleConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

final class MapConverter
extends GroupConverter {
    private final MapKeyValueConverter keyValue;
    private final ParentValueContainer parent;
    private Map<String, Object> buffer = new BufferMap();
    private Object currentKey;
    private Object currentValue;

    MapConverter(GroupType parquetSchema, Schema.FieldSchema pigSchema, ParentValueContainer parent, boolean numbersDefaultToZero, boolean columnIndexAccess) throws FrontendException {
        if (parquetSchema.getFieldCount() != 1) {
            throw new IllegalArgumentException("maps have only one field. " + parquetSchema);
        }
        this.parent = parent;
        this.keyValue = new MapKeyValueConverter(parquetSchema.getType(0).asGroupType(), pigSchema.schema.getField(0), numbersDefaultToZero, columnIndexAccess);
    }

    @Override
    public Converter getConverter(int fieldIndex) {
        if (fieldIndex != 0) {
            throw new IllegalArgumentException("maps have only one field. can't reach " + fieldIndex);
        }
        return this.keyValue;
    }

    @Override
    public final void start() {
        this.buffer.clear();
    }

    @Override
    public void end() {
        this.parent.add(new LinkedHashMap<String, Object>(this.buffer));
    }

    final class StringKeyConverter
    extends PrimitiveConverter {
        StringKeyConverter() {
        }

        @Override
        public final void addBinary(Binary value) {
            MapConverter.this.currentKey = value.toStringUsingUTF8();
        }
    }

    final class MapKeyValueConverter
    extends GroupConverter {
        private final Converter keyConverter;
        private final Converter valueConverter;

        MapKeyValueConverter(GroupType parquetSchema, Schema.FieldSchema pigSchema, boolean numbersDefaultToZero, boolean columnIndexAccess) {
            if (parquetSchema.getFieldCount() != 2 || !parquetSchema.getType(0).getName().equals("key") || !parquetSchema.getType(1).getName().equals("value")) {
                throw new IllegalArgumentException("schema does not match map key/value " + parquetSchema);
            }
            try {
                this.keyConverter = TupleConverter.newConverter(new PigSchemaConverter().convertField(parquetSchema.getType(0)).getField(0), parquetSchema.getType(0), new ParentValueContainer(){

                    @Override
                    void add(Object value) {
                        MapConverter.this.currentKey = value;
                    }
                }, numbersDefaultToZero, columnIndexAccess);
            }
            catch (FrontendException fe) {
                throw new SchemaConversionException("can't convert keytype " + parquetSchema.getType(0), fe);
            }
            this.valueConverter = TupleConverter.newConverter(pigSchema, parquetSchema.getType(1), new ParentValueContainer(){

                @Override
                void add(Object value) {
                    MapConverter.this.currentValue = value;
                }
            }, numbersDefaultToZero, columnIndexAccess);
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            if (fieldIndex == 0) {
                return this.keyConverter;
            }
            if (fieldIndex == 1) {
                return this.valueConverter;
            }
            throw new IllegalArgumentException("only the key (0) and value (1) fields expected: " + fieldIndex);
        }

        @Override
        public final void start() {
            MapConverter.this.currentKey = null;
            MapConverter.this.currentValue = null;
        }

        @Override
        public void end() {
            MapConverter.this.buffer.put(MapConverter.this.currentKey.toString(), MapConverter.this.currentValue);
            MapConverter.this.currentKey = null;
            MapConverter.this.currentValue = null;
        }
    }

    private static final class BufferMap
    extends AbstractMap<String, Object> {
        private List<Map.Entry<String, Object>> entries = new ArrayList<Map.Entry<String, Object>>();
        private Set<Map.Entry<String, Object>> entrySet = new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return entries.iterator();
            }

            @Override
            public int size() {
                return entries.size();
            }
        };

        private BufferMap() {
        }

        @Override
        public Tuple put(String key, Object value) {
            this.entries.add(new AbstractMap.SimpleImmutableEntry<String, Object>(key, value));
            return null;
        }

        @Override
        public void clear() {
            this.entries.clear();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.entrySet;
        }
    }
}

